<?php

namespace App\Services\Master;

use App\Models\Masters\MenuMaster;
use App\Models\Masters\Privilege;
use App\Models\User;
use Auth;
use Session;
use Illuminate\Support\Facades\Cache;

class MenuService
{

    public function __construct() {}

    public function getMenus($type = null)
    {
        $menus = $this->getMenuMaster(0, $type);
        foreach ($menus as $menu) {
            $menu->subMenu = $this->getMenuMaster($menu->id, $type);
        }
        return $menus;

        // Cache key, varies if type is provided
        $userId = auth()->id();
        $cacheKey = "menus_user_{$userId}";

        return Cache::remember($cacheKey, now()->addMinutes(60), function () use ($type) {
            $sessionMenu = Session::get('sessionMenu');

            $menus = MenuMaster::where('status', MenuMaster::STATUS_ACTIVE)
                ->when(is_null($type), function ($query) use ($sessionMenu) {
                    $query->whereIn('id', $sessionMenu);
                })
                ->orderBy('sort')
                ->get();

            $grouped = $menus->groupBy('p_menu');

            $finalMenus = $grouped->get(0, collect())->map(function ($menu) use ($grouped) {
                $menu->subMenu = $grouped->get($menu->id, collect());
                return $menu;
            });

            return $finalMenus;
        });
    }

    public function getMenuMaster($parentId, $type)
    {
        $sessionMenu = Session::get('sessionMenu');
        $sql = MenuMaster::where('status', MenuMaster::STATUS_ACTIVE);
        $sql->where('p_menu', $parentId);
        $sql->orderBy('sort');
        if (is_null($type)) {
            $sql->whereIn('id', $sessionMenu);
        }
        $menus = $sql->get();
        return $menus;
    }

    public function getRoleMenus($role = null)
    {
        $menuId = [];
        $loggedInUserRole = Auth::user()->role;
        if (!is_null($loggedInUserRole)) {

            if ($role) {
                $menu = Privilege::where('role', $role)->get();
                $menuId = $menu->pluck('menu');
                Session::put('loggedUser', User::LOGGED_USER_APP_USER);
                Session::put('privilege', $menu);
            }
        } else {
            $menu = MenuMaster::whereStatus(MenuMaster::STATUS_ACTIVE)->get();
            $menuId = $menu->pluck('id');
            Session::put('loggedUser', User::LOGGED_USER_SUPER_ADMIN);
        }

        Session::put('sessionMenu', $menuId);
        Session::put('sessionTheme', config('constants.SESSION_THEME'));
    }
}
