<?php

namespace App\Services\Master;

use App\Models\RoleMaster;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class RoleService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $data = RoleMaster::whereNotIn('id', RoleMaster::HIDDEN_ROLES);
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = RoleMaster::find($id);
            $data->route = route('role.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new RoleMaster();
            $data->route = route('role.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('role.index');
        $data->breadcrumbTitle = 'Role';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $roleId = $request->has('roleId') ? $request->get('roleId') : '';

        if ($roleId) {
            $data = RoleMaster::find($roleId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new RoleMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->description = $name;
        $data->save();

        if ($data) {
            return true;
        }
    }

}
