<?php

namespace App\Services\Master;

use App\Models\Masters\SchemeMaster;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class SchemeService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $city = SchemeMaster::orderBy('id');
        return $city;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = SchemeMaster::find($id);
            $data->route = route('scheme.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new SchemeMaster();
            $data->route = route('scheme.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('scheme.index');
        $data->breadcrumbTitle = 'Scheme';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $schemeId = $request->has('schemeId') ? $request->get('schemeId') : '';

        if ($schemeId) {
            $data = SchemeMaster::find($schemeId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new SchemeMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->save();

        if ($data) {
            return true;
        }
    }

}
