<?php

namespace App\Services\Master;

use App\Models\ApplicationSettings;
use App\Models\Transactions\BeneficiaryImport;
use Illuminate\Http\Request as HttpRequest;
use Auth;
use stdClass;
use DB;
use Log;
use Illuminate\Support\Facades\Artisan;

class SettingsService
{


  public function isNew($id = null)
  {

    $data = ApplicationSettings::all();
    $data->settings = new stdClass;
    foreach ($data as $value) {
      $data->settings->{$value->setting_name} = $value->setting_value;
    }
    $data->route = route('settings.update', 1);
    $data->method = 'PUT';
    $data->breadcrumbName = 'Edit';
    $data->breadcrumbAction = route('settings.index');
    $data->breadcrumbTitle = 'Settings';
    return $data;
  }

  public function saveData(HttpRequest $request, $id = null)
  {
    foreach ($request->all() as $key => $value) {
      $setting = ApplicationSettings::where('setting_name', $key)->first();
      if ($setting) {
        $setting->setting_value = $value;
        $setting->save();
      }
    }
    return true;
  }

  function deletePendingCalls(HttpRequest $request)
  {
    try {
      DB::beginTransaction();
      if (BeneficiaryImport::where('status', 1)->where('source', 1)->update(['updated_by' => Auth::user()->id])) {
        if (BeneficiaryImport::where('status', 1)->where('source', 1)->delete()) {
          DB::commit();
          return ['status' => true];
        }
      }
    } catch (\Exception $e) {
      Log::info('deletePendingCalls error: ' . $e->getMessage());
      DB::rollback();
    }
  }

  function reallocateCalls(HttpRequest $request)
  {
    Artisan::call('call:allocate');
    return ['status' => true];
  }
}
