<?php

namespace App\Services\Reports;

use App\Models\UsersCallLogs;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;

class CallLogsService
{

    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = UsersCallLogs::select(
            'beneficiary_import.customer_name',
            'users_call_logs.customer_mobile',
            'users_call_logs.call_type',
            'users_call_logs.call_duration',
            'agent_master.name as agentName',
            'branch_master.name as branchName',
            DB::raw('DATE_FORMAT(users_call_logs.call_date_time, "%d/%m/%Y %h:%i %p") as callDate'),
            DB::raw('"test remarks" as remarks'),
            DB::raw('"<i class=\"fe fe-download attachment_icon\"></i>" as recording')
        )
            ->leftJoin('beneficiary_import', 'beneficiary_import.id', 'users_call_logs.beneficiary_id')
            ->join('agent_master', 'agent_master.id', 'users_call_logs.agent_id')
            // ->join('agent_mapping', 'agent_mapping.branch_id', 'agent_master.id')
            ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->whereDate('users_call_logs.call_date_time', '>=', $args->fromDate)
            ->whereDate('users_call_logs.call_date_time', '<=', $args->toDate);
        if ($args->agent) {
            $sql->where('users_call_logs.agent_id', $args->agent);
        }
        if ($args->branch) {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        $sql->groupBy('users_call_logs.id');
        $sql->orderBy('users_call_logs.call_date_time','desc');
        return $sql;
    }
}
