<?php

namespace App\Services\Reports;

use App\Models\Masters\CallSkipReason;
use App\Models\Masters\CityMaster;
use App\Services\Reports\ReportService;
use App\Utilities\AppClass;
use Auth;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;

class CallsReportService
{

    private $reportService;
    private $report;

    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
        $this->report = new Collection();
        $this->header = new Collection();
    }

    public function getCallsReport(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $data = new AppClass();
        $this->header = $this->getTableColumns();
        $data->rows = $this->getTableRows($args);
        $this->getreport($args, $data);
        $reports = $this->report;
        $headers = $this->header;
        $html = view('reports.calls-report-details', compact('reports', 'headers'))->render();
        $response = [
            'status' => true,
            'redirect' => null,
            'renderId' => '#report_content',
            'html' => $html,
            'tableId' => '#calls-report-datatable',
            'export' => true,
        ];
        return response()->json($response);
    }

    public function getreport($args, $data)
    {
        if ($data->rows) {
            foreach ($data->rows as $district) {
                $args->districtId = $district->id;
                $feedbacks = $this->coreFeedbackReport($args);
                if ($feedbacks && count($feedbacks) > 0) {
                    $this->makeReport($feedbacks, $data);
                }
            }
        }
    }

    public function makeReport($feedbacks, $data)
    {
        $reportColumns = $this->getReportColumnAttributes($data);
        $this->addDataToReport($feedbacks, $reportColumns);
    }

    public function addDataToReport($feedbacks, $reportColumns)
    {
        $answerdCalls = 0;
        $unanswerdCalls = 0;
        $tempReport = new Collection();
        foreach ($feedbacks as $feedback) {

            if (is_null($feedback->is_answered) || $feedback->is_answered == 1) {
                if (is_null($feedback->is_answered)) {
                    $answerdCalls += $feedback->callCount1;
                } else {
                    $answerdCalls += $feedback->callCount;
                }
            } else {
                $unanswerdCalls += $feedback->callCount;
            }

            if (!isset($tempReport[$feedback->district_id])) {
                $tempReport[$feedback->district_id] = $this->getReportColumnAttributes();
            }
            $items = $tempReport->get($feedback->district_id);
            foreach ($reportColumns as $key => $column) {
                $items->districtName = $feedback->districtName;
                if (is_null($feedback->skip_reason)) {
                    $items->feedbackCalls = $feedback->feedbackCount;
                    $items->complainCalls = $feedback->complaintCount;
                    $items->pending = $feedback->pending;
                    $items->resolved = $feedback->resolved;
                } else if ($feedback->skipReasonName == $key) {
                    $items->{$key} = $feedback->callCount;
                }
            }
        }
        $items->answeredCalls = $answerdCalls;
        $items->unAnsweredCalls = $unanswerdCalls;

        foreach ($tempReport as $row) {
            $row->totalCalls = $this->getTotalCalls($row);
            $this->report->add($row);
        }
    }

    public function getTotalCalls($data)
    {
        $totalCalls = 0;
        foreach ($this->header as $header) {
            $totalCalls += $data->{$header->name};
        }
        $totalCalls += $data->feedbackCalls + $data->complainCalls;
        return $totalCalls;
    }

    public function getReportColumnAttributes()
    {
        $attributes = new AppClass();
        foreach ($this->header as $header) {
            $attributes->{$header->name} = null;
        }
        $attributes->districtName = null;
        $attributes->feedbackCalls = null;
        $attributes->complainCalls = null;
        $attributes->totalCalls = null;
        $attributes->answeredCalls = null;
        $attributes->unAnsweredCalls = null;
        $attributes->pending = null;
        $attributes->resolved = null;
        return $attributes;
    }

    public function coreFeedbackReport($args)
    {

        $sql = DB::table('beneficiary_import')
            ->join('program_master', 'program_master.id', 'beneficiary_import.program_id')
            ->join('users', 'users.id', 'beneficiary_import.updated_by')
            ->join('city_master', 'city_master.id', 'beneficiary_import.district_id')
            ->leftJoin('call_skip_reason', 'call_skip_reason.id', 'beneficiary_import.skip_reason')
            ->leftJoin('feedback', 'feedback.beneficiary_ref_id', 'beneficiary_import.id')
            ->where('beneficiary_import.status', '!=', 1)
            ->whereDate('beneficiary_import.updated_at', '>=', $args->fromDate)
            ->whereDate('beneficiary_import.updated_at', '<=', $args->toDate);
        if ($args->program) {
            $sql->where('beneficiary_import.program_id', $args->program);
        }
        $sql->where('beneficiary_import.district_id', $args->districtId);
        $sql->groupBy('beneficiary_import.skip_reason');
        if (!is_null(Auth::user()->role)) {
            $sql->select(
                'beneficiary_import.skip_reason',
                'beneficiary_import.district_id',
                'call_skip_reason.name as skipReasonName',
                'call_skip_reason.is_answered',
                'city_master.name as districtName',
                DB::raw('COUNT(beneficiary_import.id) as callCount'),
                DB::raw('COUNT(CASE WHEN feedback.is_show = 1 THEN feedback.id END) as callCount1'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 AND feedback.is_show = 1 THEN feedback.id END) as complaintCount'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 0 AND feedback.is_show = 1 THEN feedback.id END) as feedbackCount'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 AND feedback.is_show = 1 AND feedback.resolved_status = 0 THEN feedback.id END) as pending'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 AND feedback.is_show = 1 AND feedback.resolved_status = 1 THEN feedback.id END) as resolved'),
            );
        } else {
            $sql->select(
                'beneficiary_import.skip_reason',
                'beneficiary_import.district_id',
                'call_skip_reason.name as skipReasonName',
                'call_skip_reason.is_answered',
                'city_master.name as districtName',
                DB::raw('COUNT(beneficiary_import.id) as callCount'),
                DB::raw('COUNT(feedback.id) as callCount1'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 THEN feedback.id END) as complaintCount'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 0 THEN feedback.id END) as feedbackCount'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 AND feedback.resolved_status = 0 THEN feedback.id END) as pending'),
                DB::raw('COUNT(CASE WHEN feedback.is_compliant = 1 AND feedback.resolved_status = 1 THEN feedback.id END) as resolved'),
            );
        }

        $data = $sql->get();
        return $data;
    }

    public function getTableColumns()
    {
        $columns = CallSkipReason::whereStatus(CallSkipReason::STATUS_ACTIVE)->select('id', 'name')->get();
        return $columns;
    }

    public function getTableRows($args)
    {
        $sql = CityMaster::whereStatus(CityMaster::STATUS_ACTIVE)->orderBy('name');
        if ($args->district) {
            $sql->where('id', $args->district);
        }
        $district = $sql->get();
        return $district;
    }
}
