<?php

namespace App\Services\Reports;

use App\Models\Masters\AgentMaster;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class NocallNologinService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $date = Carbon::parse($args->date)->format('d-m-Y');
        $sql = AgentMaster::select(
            'agent_master.id',
            'cluster_master.name as clusterName',
            'branch_master.name as branchName',
            'agent_master.name as agentName',
            'agent_master.emp_no as agentId',
            DB::raw('"' . $date . '" as date')
        )
            ->leftJoin('branch_master', 'agent_master.branch_id', '=', 'branch_master.id')
            ->leftJoin('agents_login', function ($join) use ($args) {
                $join->on('agents_login.agent_id', '=', 'agent_master.id')
                    ->where('agents_login.date', $args->date);
            })
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'agent_master.branch_id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE)
            ->whereNull('agents_login.agent_id')
            ->whereNull('agent_master.deleted_at');

        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }

        if ($args->branch && $args->branch !== 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        if ($args->agent && $args->agent !== 'All') {
            $sql->where('agent_master.id', $args->agent);
        }
        return $sql;
    }

    function getReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'nocalls-nologin-report-excel';
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->agentLabel = $this->reportService->getAgentById($args->agent);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
