<?php

namespace App\Services\Reports;

use App\Models\Masters\AgentMaster;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;

class PresentLoggedInService
{
    private $reportService;
    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);

        $fromDate = $args->fromDate->format('Y-m-d');
        $toDate = $args->toDate->format('Y-m-d');

        $sql = AgentMaster::select(
            'agent_master.name as agentName',
            'agent_master.phone',
            'branch_master.name as branchName',
            'agent_master.emp_no as empId',
            'cluster_master.name as clusterName',
            'designation_master.name as designationName',
            'brand_master.name as brandName',
            'class_master.name as className',
            // DB::raw('DATE_FORMAT(agents_login.date, "%d-%m-%Y") as date'),
            DB::raw('DATE_FORMAT(COALESCE(agents_login.date, agents_attendance.date), "%d-%m-%Y") as date'),
            DB::raw('DATE_FORMAT(agents_login.login_in, "%h:%i %p") as login_in'),
            DB::raw('DATE_FORMAT(agents_login.log_out, "%h:%i %p") as log_out'),
            DB::raw('DATE_FORMAT(agents_attendance.login_in, "%h:%i %p") as sys_login'),
            DB::raw('DATE_FORMAT(agents_attendance.log_out, "%h:%i %p") as sys_logout')
        )
            ->leftJoin('agents_login', function ($join) use ($fromDate, $toDate) {
                $join->on('agent_master.id', '=', 'agents_login.agent_id')
                    ->whereBetween('agents_login.date', [$fromDate, $toDate]);
            })
            ->leftJoin('agents_attendance', function ($join) use ($fromDate, $toDate) {
                $join->on('agent_master.id', '=', 'agents_attendance.agent_id')
                    ->whereBetween('agents_attendance.date', [$fromDate, $toDate]);
            })
            ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->leftJoin('designation_master', 'designation_master.id', 'agent_master.designation')
            ->leftJoin('brand_master', 'brand_master.id', 'agent_master.brand')
            ->leftJoin('class_master', 'class_master.id', 'agent_master.class')
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'agent_master.branch_id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        if ($args->agent && $args->agent != 'All') {
            $sql->where('agent_master.id', $args->agent);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        $sql->groupBy('agent_master.id');
        $sql->orderBy('agentName');
        return $sql;
    }
}
