<?php

namespace App\Services\Reports;

use App\Utilities\AppClass;
use Illuminate\Support\Collection;


class PresentationEntities
{
    const TOTAL_DISTRICTS_COVERED = 'TOTAL DISTRICTS COVERED';
    const TOTAL_CALLS_MADE = 'Total CallsMade';
    const ANSWERED_CALLS = 'Answered calls';
    const UN_ANSWERED_CALLS = 'Un Answered Calls';
    const TOTAL_FEEDBACK_RECEIVED = 'Total Feedback Received';
    const TOTAL_COMPLAINTS_RECEIVED = 'Total Complaints Received';

    const PROGRAM_WITH_HIGH_COMPLAINTS = 'Program with High Complaints';
    const TOTAL_NO_OF_COMPLAINTS = 'Total No Of Complaints';
    const DISTRICT_WITH_HIGH_COMPLAINTS = 'District with High Complaints';

    const COMPLAINTS_RECEIVED = 'Complaints Received';
    const WORKER_RESOLVED = 'Worker Resolved';
    const CDPO_RESOLVED = 'CDPO Resolved';
    const DPO_RESOLVED = 'DPO Resolved';
    const PENDING_TO_RESOLVE = 'Pending to Resolve';
    const AVG_TIME_TO_RESOLVE = 'Avg time to Resolve';
    
    public function __construct()
    {
    }

    public function totalCallsEntities()
    {
        $data = new Collection();

        $districts = new AppClass();
        $districts->count = 0;
        $districts->title = self::TOTAL_DISTRICTS_COVERED;
        $districts->class = 'text-success fa fa-university';
        $districts->showLink = false;
        $data->add($districts);

        $calls = new AppClass();
        $calls->count = 0;
        $calls->title = self::TOTAL_CALLS_MADE;
        $calls->class = 'text-warning fa fa-phone';
        $calls->showLink = false;
        $data->add($calls);

        $answer = new AppClass();
        $answer->count = 0;
        $answer->title = self::ANSWERED_CALLS;
        $answer->class = 'text-primary fa fa-volume-control-phone';
        $answer->showLink = false;
        $answer->showPercent = true;
        $answer->percentage = 0;
        $data->add($answer);

        $unanswer = new AppClass();
        $unanswer->count = 0;
        $unanswer->title = self::UN_ANSWERED_CALLS;
        $unanswer->class = 'text-danger fa fa-phone-square';
        $unanswer->showLink = false;
        $unanswer->showPercent = true;
        $unanswer->percentage = 0;
        $data->add($unanswer);

        $feedbacks = new AppClass();
        $feedbacks->count = 0;
        $feedbacks->title = self::TOTAL_FEEDBACK_RECEIVED;
        $feedbacks->class = 'text-success fa fa-bar-chart';
        $feedbacks->showLink = false;
        $feedbacks->showPercent = true;
        $feedbacks->percentage = 0;
        $data->add($feedbacks);
        
        $complaints = new AppClass();
        $complaints->count = 0;
        $complaints->title = self::TOTAL_COMPLAINTS_RECEIVED;
        $complaints->class = 'text-warning fa fa-check-square';
        $complaints->showLink = false;
        $complaints->showPercent = true;
        $complaints->percentage = 0;
        $data->add($complaints);

        return $data;
    }

    public function highComplaintsProgramEntities()
    {
        $data = new Collection();

        $program = new AppClass();
        $program->count = 0;
        $program->title = self::PROGRAM_WITH_HIGH_COMPLAINTS;
        $program->class = 'text-success fa fa-television';
        $program->showLink = false;
        $data->add($program);

        $districts = new AppClass();
        $districts->count = 0;
        $districts->title = self::DISTRICT_WITH_HIGH_COMPLAINTS;
        $districts->class = 'text-warning fa fa-university';
        $districts->showLink = false;
        $data->add($districts);

        $complaints = new AppClass();
        $complaints->count = 0;
        $complaints->title = self::TOTAL_NO_OF_COMPLAINTS;
        $complaints->class = 'text-danger fa fa-language';
        $complaints->showLink = false;
        $data->add($complaints);
        
        return $data;
    }

    
    public function getEscDashboardEntity()
    {
        $data = new Collection();

        $items = new AppClass();
        $items->title = self::COMPLAINTS_RECEIVED;
        $items->count = 0;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = true;
        $data->add($items);

        $items = new AppClass();
        $items->count = 0;
        $items->title = self::WORKER_RESOLVED;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = true;
        $data->add($items);

        $items = new AppClass();
        $items->count = 0;
        $items->title = self::CDPO_RESOLVED;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = true;
        $data->add($items);

        $items = new AppClass();
        $items->count = 0;
        $items->title = self::DPO_RESOLVED;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = true;
        $data->add($items);

        $items = new AppClass();
        $items->count = 0;
        $items->title = self::PENDING_TO_RESOLVE;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = true;
        $data->add($items);

        $items = new AppClass();
        $items->count = 0;
        $items->title = self::AVG_TIME_TO_RESOLVE;
        $items->class = 'fa fa-bar-chart text-success';
        $items->showLink = false;
        $data->add($items);

        return $data;
    }

}
