<?php

namespace App\Services\Reports;

use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\ClusterMaster;
use App\Utilities\ReportArguments;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use stdClass;

class ReportService
{
    public function processrequestFilters(Request $request)
    {
        $params = new ReportArguments();
        $params->dateRange = isIssetValue($request, 'dateRange');
        $date = isIssetValue($request, 'date');
        $params->agent = isIssetValue($request, 'agent');
        $params->branch = isIssetValue($request, 'branch');
        $params->cluster = isIssetValue($request, 'cluster');
        $params->years = isIssetValue($request, 'years');
        $params->months = isIssetValue($request, 'months');
        $params->telecallingSales = isIssetValue($request, 'telecallingSales');
        $params->source = isIssetValue($request, 'source');
        $params->status = isIssetValue($request, 'status');
        $params->priority = isIssetValue($request, 'priority');
        $params->createdBy = isIssetValue($request, 'createdBy');
        $params->category = isIssetValue($request, 'category');
        $params->department = isIssetValue($request, 'department');

        $splitDate = explode('-', $params->dateRange);

        $today = Carbon::now();
        $params->fromDate = $today;
        $params->toDate = clone $today;

        $params->date = Carbon::now()->format('Y-m-d');
        if ($date) {
            $params->date = Carbon::parse($date)->format('Y-m-d');
        }


        if (isset($splitDate[0]) && $splitDate[0] != '') {
            $fromDate = str_replace('/', '-', trim($splitDate[0]));
            $params->fromDate = Carbon::parse($fromDate);
        }
        if (isset($splitDate[1]) && $splitDate[1] != '') {
            $toDate = str_replace('/', '-', trim($splitDate[1]));
            $params->toDate = Carbon::parse($toDate);
        }

        return $params;
    }

    function getBranchById($id)
    {
        if ($id > 0) {
            $data = BranchMaster::find($id);
            if ($data) {
                return $data->name;
            }
        }
    }

    function getAgentById($id)
    {
        if ($id > 0) {
            $data = AgentMaster::find($id);
            if ($data) {
                return $data->name;
            }
        }
    }

    function getClusterById($id)
    {
        if ($id > 0) {
            $data = ClusterMaster::find($id);
            if ($data) {
                return $data->name;
            }
        }
    }

    function formatCreatedDateFromDt($date)
    {
        $keyword = trim($date, '^$');
        if ($keyword != 'null') {
            $keyword = str_replace('\\', '', $keyword);
            $formattedKeyword = \Carbon\Carbon::createFromFormat('d/m/Y h:i A', $keyword)->format('Y-m-d H:i');
            return $formattedKeyword;
        }
        return '';
    }

    function formatDateFromDt($date)
    {
        $keyword = trim($date, '^$');
        if ($keyword != 'null') {
            $keyword = str_replace('\\', '', $keyword);
            $keyword = str_replace('/', '-', $keyword);
            $date = Carbon::parse($keyword)->format('Y-m-d');
            return $date;
        }
        return '';
    }

    function formatDtKeyword($keyword)
    {
        $keyword = trim($keyword, '^$');
        if ($keyword != 'null') {
            return $keyword;
        }
        return '';
    }

    function getLastTwoMonths(Request $request)
    {
        $givenDate = Carbon::parse($request->years . '-' . $request->months . '-01');
        $months = [];
        for ($i = 0; $i < 2; $i++) {
            $cloneDate = $givenDate->copy();
            $cloneDate->subMonths($i);
            $startOfMonth = $cloneDate->startOfMonth()->format('Y-m-d');
            $endOfMonth = $cloneDate->endOfMonth()->format('Y-m-d');
            $months[] = [
                'fullText' => $cloneDate->format('M Y'),
                'start' => $startOfMonth,
                'end' => $endOfMonth,
            ];
        }

        $months = array_reverse($months);
        $monthStart = $months[0]['start'];
        $monthEnd = end($months)['end'];
        $data = new stdClass;
        $data->data = $months;
        $data->startDate = $monthStart;
        $data->endDate = $monthEnd;
        return $data;
    }
}
