<?php

namespace App\Services\Reports;

use App\Models\CRMTickets;
use App\Models\ExcelCampaign;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class VendorCampaignReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $fromDate = Carbon::parse($args->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($args->toDate)->format('Y-m-d');
        $sql = ExcelCampaign::select(
            'branch_master.name as branchName',
            'excel_campaign.*',
            'cluster_master.name as clusterName',
            'agent_master.name as agentName',
            DB::raw("DATE_FORMAT(excel_campaign.date_created, '%d-%b-%Y %h:%i %p') as createdTime"),
            DB::raw('
            CASE 
                WHEN excel_campaign.read_status = 1 THEN "Seen"
                WHEN excel_campaign.read_status = 2 THEN "Called"
                ELSE "Pending"
            END as readStatus
        '),
        )
            ->join('branch_master', 'branch_master.id', 'excel_campaign.branch_id')
            ->where('excel_campaign.date_created', '>=', $fromDate . ' 00:00:00')
            ->where('excel_campaign.date_created', '<=', $toDate . ' 23:59:59')
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'branch_master.id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id')
            ->leftJoin('beneficiary_import', 'beneficiary_import.excel_campaign_id', 'excel_campaign.id')
            ->leftJoin('agent_master', 'agent_master.id', 'beneficiary_import.agent_id');

        if ($args->branch && $args->branch != 'All') {
            $sql->where('excel_campaign.branch_id', $args->branch);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        if ($args->agent && $args->agent != 'All') {
            $sql->where('agent_master.id', $args->agent);
        }
        $sql->groupBy('excel_campaign.id');
        return $sql;
    }

    function getReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'vendor-campaign-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        $params->agentLabel = $this->reportService->getAgentById($args->agent);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
