<?php

namespace App\Services;

use App\Models\CustomerCoupons;
use App\Models\EnquiryHistory;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\ReferralCampaign;
use App\Models\ReferrerVouchers;
use App\Models\Sales;
use App\Models\Transactions\BeneficiaryImport;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Log;
use stdClass;

class SalesService
{

    private $commonService;
    const ENQUIRY_IGNORE_DESCRIPTIONS = ['Model not available with us', 'Not eligible for finance'];

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    public function addSalesEnquiryData(Request $request)
    {
        try {
            Log::info('addSalesEnquiryData : ' . json_encode($request->all()));
            $data = $request->data;
            if ($data) {
                $add = 0;
                foreach ($data as $row) {

                    $branch = BranchMaster::where('sap_code', $row['branch'])->first();
                    //check agent number exists in table
                    if ($row['salesmanMobile']) {
                        $mobile = $this->commonService->formatMobileNo($row['salesmanMobile']);
                        $agent = AgentMaster::where('phone', $mobile)->first();
                    }

                    if ($row['type'] == 'sales') {
                        // $salesCount = SalesHistory::where('sap_ref_id', $row['refId'])->count();
                        // if ($salesCount == 0) {

                        $customerNumber = $this->commonService->formatMobileNo($row['mobile']);
                        $customer = BeneficiaryImport::where('mobile_number', $customerNumber)->first();

                        $sales = new Sales();
                        $sales->invoice_date = Carbon::parse($row['date']);
                        $sales->mobile = isset($row['mobile']) ? $row['mobile'] : null;
                        $sales->branch = isset($row['branch']) ? $row['branch'] : null;
                        $sales->customer_name = isset($row['customerName']) ? $row['customerName'] : null;
                        $sales->product = isset($row['product']) ? $row['product'] : null;
                        $sales->description = isset($row['description']) ? $row['description'] : null;
                        $sales->amount = isset($row['amount']) ? $row['amount'] : null;
                        $sales->sap_ref_id = isset($row['refId']) ? $row['refId'] : null;
                        $sales->beneficiary_id = isset($customer->id) ? $customer->id : null;
                        $sales->branch_id = isset($branch->id) ? $branch->id : null;
                        $sales->followup_date = isset($row['followupDate']) ? Carbon::parse($row['followupDate']) : null;
                        $sales->order_source = isset($row['orderSource']) ? $row['orderSource'] : null;
                        $sales->sale_employee = isset($row['saleEmployee']) ? $row['saleEmployee'] : null;
                        $sales->user_code_id = isset($row['userCodeId']) ? $row['userCodeId'] : null;
                        $sales->category = isset($row['category']) ? $row['category'] : null;
                        $sales->doc_status = isset($row['docStatus']) ? $row['docStatus'] : null;
                        $sales->enquiry_reason = isset($row['enquiryReason']) ? $row['enquiryReason'] : null;
                        $sales->designation = isset($row['designation']) ? $row['designation'] : null;
                        $sales->remarks = isset($row['remarks']) ? $row['remarks'] : null;
                        $sales->salesman_mobile = isset($row['salesmanMobile']) ? $row['salesmanMobile'] : null;
                        $sales->coupon_code = isset($row['couponCode']) ? $row['couponCode'] : null;
                        $sales->agent_id = isset($agent->id) ? $agent->id : null;
                        if ($sales->save()) {
                            // $this->generateCouponCode();
                            // if (!$sales->coupon_code) {
                            //     $this->sendCouponCodeToCustomer($sales);
                            // }
                            // $this->checkReferrerCouponCode($sales);
                            $add++;
                        }
                        // }
                    } else if ($row['type'] == 'enquiry') {
                        // $enquiryCount = EnquiryHistory::where('sap_ref_id', $row['refId'])->count();
                        // if ($enquiryCount == 0) {
                        // if (!in_array($row['enquiryReason'], self::ENQUIRY_IGNORE_DESCRIPTIONS)) {
                            $enquiry = new EnquiryHistory();
                            $enquiry->date = Carbon::parse($row['date']);
                            $enquiry->mobile = isset($row['mobile']) ? $row['mobile'] : null;
                            $enquiry->branch = isset($row['branch']) ? $row['branch'] : null;
                            $enquiry->customer_name = isset($row['customerName']) ? $row['customerName'] : null;
                            $enquiry->product = isset($row['product']) ? $row['product'] : null;
                            $enquiry->description = isset($row['description']) ? $row['description'] : null;
                            $enquiry->sap_ref_id = isset($row['refId']) ? $row['refId'] : null;
                            $enquiry->branch_id = isset($branch->id) ? $branch->id : null;
                            $enquiry->followup_date = isset($row['followupDate']) ? Carbon::parse($row['followupDate']) : null;
                            $enquiry->order_source = isset($row['orderSource']) ? $row['orderSource'] : null;
                            $enquiry->sale_employee = isset($row['saleEmployee']) ? $row['saleEmployee'] : null;
                            $enquiry->user_code_id = isset($row['userCodeId']) ? $row['userCodeId'] : null;
                            $enquiry->category = isset($row['category']) ? $row['category'] : null;
                            $enquiry->doc_status = isset($row['docStatus']) ? $row['docStatus'] : null;
                            $enquiry->enquiry_reason = isset($row['enquiryReason']) ? $row['enquiryReason'] : null;
                            $enquiry->designation = isset($row['designation']) ? $row['designation'] : null;
                            $enquiry->remarks = isset($row['remarks']) ? $row['remarks'] : null;
                            $enquiry->salesman_mobile = isset($row['salesmanMobile']) ? $row['salesmanMobile'] : null;
                            $enquiry->agent_id = isset($agent->id) ? $agent->id : null;
                            $enquiry->amount = isset($row['amount']) ? $row['amount'] : null;
                            $enquiry->qty = isset($row['qty']) ? $row['qty'] : null;

                            if ($enquiry->save()) {

                                //insert data to beneficiary table
                                $id = $enquiry->id;
                                $customer = new BeneficiaryImport();
                                $customer->branch_id = isset($branch->id) ? $branch->id : null;
                                $customer->customer_name = isset($row['customerName']) ? $row['customerName'] : null;
                                $customer->mobile_number = isset($row['mobile']) ? $row['mobile'] : null;
                                $customer->description = isset($row['product']) ? $row['product'] : null;
                                // $customer->amount = isset($row['amount']) ? $row['amount'] : null;
                                $customer->invoice_date = Carbon::parse($row['date']);
                                $customer->sap_lead_id = $id;
                                $customer->source = BeneficiaryImport::SOURCE_TYPE_SAP;
                                $customer->save();
                                $enquiry->beneficiary_id = isset($customer->id) ? $customer->id : null;
                                $enquiry->save();
                                $add++;
                            }
                            // }
                        // }
                    }
                }
                if ($add > 0) {
                    $response = new stdClass;
                    return $this->commonService->makeSuccessResponse('saved successfully', $response);
                } else {
                    return $this->commonService->makeErrorResponse('zero insertion');
                }
            } else {
                return $this->commonService->makeErrorResponse('no data found');
            }
        } catch (\Exception $e) {
            Log::info('addSalesEnquiryData error : ' . $e->getMessage());
            return $this->commonService->makeErrorResponse($e->getMessage());
        }
    }

    function cancelSalesOrder(Request $request)
    {
        try {
            Log::info('cancelSalesOrder : ' . json_encode($request->all()));
            $data = $request->data;
            if ($data) {
                $delete = 0;
                foreach ($data as $row) {
                    if (Sales::where('sap_ref_id', $row['refId'])->delete()) {
                        $delete++;
                    }
                }
                if ($delete > 0) {
                    $response = new stdClass;
                    return $this->commonService->makeSuccessResponse('cancelled successfully', $response);
                } else {
                    return $this->commonService->makeErrorResponse('no data to cancel');
                }
            } else {
                return $this->commonService->makeErrorResponse('no data found');
            }
        } catch (\Exception $e) {
            Log::info('cancelSalesOrder error : ' . $e->getMessage());
            return $this->commonService->makeErrorResponse($e->getMessage());
        }
    }

    function sendCouponCodeToCustomer($params)
    {
        // $campaignValidity = '02/01/2025';
        $campaignValidity = Carbon::now()->addDays(7)->format('d/m/Y');
        // $campaign = ReferralCampaign::find(1);
        // $today = Carbon::now()->format('Y-m-d');
        // $amountValid = $params->amount >= $campaign->referrer_value;
        // $withinValidityPeriod = $today <= $campaign->campaign_validity;
        // $withinReferrerPeriod = $today >= $campaign->referrer_from && $today <= $campaign->referrer_to;
        if ($params->amount >= 10000) {

            // for ($i = 1; $i <= $campaign->referrer_get; $i++) {
            $coupon1 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 1000)->first();
            $coupon2 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 2000)->first();
            $coupon3 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 3000)->first();

            if ($coupon1 && $coupon2 && $coupon3) {

                $coupon1->sales_id = $params->id;
                $save1 = $coupon1->save();
                $coupon2->sales_id = $params->id;
                $save2 = $coupon2->save();
                $coupon3->sales_id = $params->id;
                $save3 = $coupon3->save();

                if ($save1 && $save2 && $save3) {
                    $customerNumber = $this->commonService->formatMobileNo($params->mobile);
                    $waParam = new stdClass;
                    $waParam->mobile = $customerNumber;
                    $waParam->name = $params->customer_name;
                    $waParam->voucherCode1 = $coupon1->coupon_code;
                    $waParam->voucherCode2 = $coupon2->coupon_code;
                    $waParam->voucherCode3 = $coupon3->coupon_code;
                    $waParam->validity = $campaignValidity;
                    $response = $this->sendReferralCoupon($waParam);
                    $decode = json_decode($response, true);
                    if (isset($decode['status']) && $decode['status'] == 'submitted') {
                        $messageId = isset($decode['messageId']) ? $decode['messageId'] : null;
                        $coupon1->message_id = $messageId;
                        $coupon1->save();
                        $coupon2->message_id = $messageId;
                        $coupon2->save();
                        $coupon3->message_id = $messageId;
                        $coupon3->save();
                    }
                }
            }
            // }
        }
    }

    function sendReferralCoupon($params)
    {

        $url = "https://api.gupshup.io/wa/api/v1/template/msg";

        $data = [
            'channel' => 'whatsapp',
            'source' => constants('GUPSHUP_WHATSAPP_SOURCE'),
            'destination' => '91' . $params->mobile,
            'src.name' => 'Xc8c5DTGK5YVdRiztBzmVuZo',
            'template' => json_encode([
                'id' => '870e2f36-6456-4b41-a576-cfa68a65f880',
                'params' => [
                    $params->name,
                    $params->validity,
                    $params->voucherCode1,
                    $params->voucherCode2,
                    $params->voucherCode3,
                ],
            ]),
            'message' => json_encode([
                'image' => [
                    'id' => '619244140530530',
                ],
                'type' => 'image',
            ]),
        ];

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Cache-Control: no-cache',
            'Content-Type: application/x-www-form-urlencoded',
            'apikey: ' . constants('GUPSHUP_API_KEY'),
        ]);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            Log::info('sendCouponCodeToCustomer : ' . json_encode(curl_error($ch)));
        } else {
            Log::info('sendCouponCodeToCustomer Response: ' . json_encode($response));
        }
        curl_close($ch);
        return $response;
    }

    function checkReferrerCouponCode($params)
    {
        if (isset($params->coupon_code) && $params->coupon_code) {

            $coupon = CustomerCoupons::select('customer_coupons.*', 'sales.customer_name', 'sales.mobile')
                ->join('sales', 'sales.id', 'customer_coupons.sales_id')
                ->where('customer_coupons.coupon_code', $params->coupon_code)
                ->whereNotNull('customer_coupons.sales_id')
                ->first();

            if ($coupon) {

                $sendCoupon = false;
                if ($coupon->coupon_amount == 1000 && $params->amount >= 10000) {
                    $sendCoupon = true;
                }
                if ($coupon->coupon_amount == 2000 && $params->amount >= 20000) {
                    $sendCoupon = true;
                }
                if ($coupon->coupon_amount == 3000 && $params->amount >= 30000) {
                    $sendCoupon = true;
                }

                if ($sendCoupon) {
                    //send coupon to customer logic here
                    $coupon->beneficiary_claimed = 1;
                    $coupon->referred_to = $params->id;
                    $coupon->save();

                    //update to referral coupon code
                    $referrerVoucher = ReferrerVouchers::whereNull('customer_coupon_id')->first();
                    if ($referrerVoucher) {
                        $referrerVoucher->customer_coupon_id = $coupon->id;
                        $referrerVoucher->save();

                        $customerNumber = $this->commonService->formatMobileNo($coupon->mobile);

                        $url = "https://api.gupshup.io/wa/api/v1/template/msg";

                        $data = [
                            'channel' => 'whatsapp',
                            'source' => constants('GUPSHUP_WHATSAPP_SOURCE'),
                            'destination' => '91' . $customerNumber,
                            'src.name' => 'Xc8c5DTGK5YVdRiztBzmVuZo',
                            'template' => json_encode([
                                'id' => '5598a191-35ec-4e9c-97d6-e28042f18859',
                                'params' => [
                                    $coupon->customer_name,
                                    $params->customer_name,
                                    $referrerVoucher->voucher_code,
                                    '31/01/2025',
                                ],
                            ]),
                            "message" => json_encode([
                                "image" => [
                                    "id" => "524640447394413"
                                ],
                                "type" => "image"
                            ])
                        ];

                        $ch = curl_init($url);

                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Cache-Control: no-cache',
                            'Content-Type: application/x-www-form-urlencoded',
                            'apikey: ' . constants('GUPSHUP_API_KEY'),
                        ]);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $response = curl_exec($ch);

                        if (curl_errno($ch)) {
                            Log::info('sendCouponCodeToCustomer : ' . json_encode(curl_error($ch)));
                        } else {
                            Log::info('sendCouponCodeToCustomer Response: ' . json_encode($response));
                        }
                        curl_close($ch);

                        $decode = json_decode($response, true);
                        if (isset($decode['status']) && $decode['status'] == 'submitted') {
                            $messageId = isset($decode['messageId']) ? $decode['messageId'] : null;
                            $referrerVoucher->message_id = $messageId;
                            $referrerVoucher->save();
                        }
                    } else {
                        Log::info('coupon code not found');
                    }
                }
            }
        } else {
            Log::info('coupon code not found in this request');
        }
    }

    function generateCouponCode()
    {
        for ($i = 0; $i < 100; $i++) {
            $randomNumber = mt_rand(1000000000000, 9999999999999);
            $code = 'VIK' . $randomNumber;
            $coupon = new CustomerCoupons();
            $coupon->coupon_code = $code;
            $coupon->save();
        }
    }
}
