<?php

namespace App\Services\Transactions;

use App\Models\AgentsAttendance;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\ClassMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\Masters\UserMaster;
use App\Models\RoleMaster;
use App\Models\User;
use Carbon\Carbon;
use Log;
use DB;
use Illuminate\Support\Facades\Hash;
use stdClass;

class GreytHrService
{

    const TELECALLER_CATEGORIES = ['PROMOTER', 'STAFF', 'BRANCH MANAGER', 'CCA'];
    const APP_USERS_CATEGORIES = ['BRANCH MANAGER'];
    const LOCATION_CATEGORY_VALUE = 1;
    const DESIGNATION_CATEGORY_VALUE = 6;
    const BRAND_NAME_CATEGORY_VALUE = 7;
    const CLASS_CATEGORY_VALUE = 8;

    private $token;
    private $type;

    public function __construct()
    {
        $this->token = null;
        $this->type = null;
    }

    function fetchData($type)
    {
        // try {
        //     DB::beginTransaction();
        $this->type = $type;
        //generate access token
        $this->token = $this->generateToken();
        //get all employees
        $this->getAllEmployees();
        //get employee attendance
        $this->getAttendance();
        //     DB::commit();
        // } catch (\Exception $e) {
        //     DB::rollback();
        //     Log::info('graythr fetching error : ' . $e->getMessage());
        // }
    }

    function getIntegrationUrl($type)
    {
        if ($this->type == 1) {
            if ($type == 'Authorization') {
                $url = constants('GREYTHR_AUTH_TOKEN');
            }
            if ($type == 'greythr-domain') {
                $url = constants('GREYTHR_COMPANY_DOMAIN');
            }
            if ($type == 'company') {
                $url = constants('GREYTHR_COMPANY_URL');
            }
            if ($type == 'api') {
                $url = constants('GREYTHR_API_URL');
            }
        } else {
            if ($type == 'Authorization') {
                $url = constants('GREYTHR_AUTH_TOKEN1');
            }
            if ($type == 'greythr-domain') {
                $url = constants('GREYTHR_COMPANY_DOMAIN1');
            }
            if ($type == 'company') {
                $url = constants('GREYTHR_COMPANY_URL1');
            }
            if ($type == 'api') {
                $url = constants('GREYTHR_API_URL');
            }
        }
        return $url;
    }

    public function coreGuzzleGet($url, $formParams = [])
    {

        $headers = [
            'Authorization' => $this->getIntegrationUrl('Authorization'),
            'ACCESS-TOKEN' => $this->token,
            'x-greythr-domain' => $this->getIntegrationUrl('greythr-domain'),
        ];

        $client = new \GuzzleHttp\Client();
        $res = $client->get($url, [
            'form_params' => $formParams,
            'headers' => $headers
        ]);

        $return = new stdClass;
        $return->status = $res->getStatusCode();
        $return->data = json_decode($res->getBody()->getContents());
        return $return;
    }

    public function coreGuzzleQuery($url, $query)
    {
        $headers = [
            'Authorization' => $this->getIntegrationUrl('Authorization'),
            'ACCESS-TOKEN' => $this->token,
            'x-greythr-domain' => $this->getIntegrationUrl('greythr-domain'),
        ];
        $client = new \GuzzleHttp\Client(['verify' => false]);
        $res = $client->get($url, [
            'headers' => $headers,
            'query' => $query,
        ]);

        $return = new stdClass;
        $return->status = $res->getStatusCode();
        $return->data = json_decode($res->getBody()->getContents());
        return $return;
    }

    public function coreGuzzlePost($url, $formParams = [])
    {
        $headers = [
            'Authorization' => $this->getIntegrationUrl('Authorization'),
            'ACCESS-TOKEN' => $this->token,
            'x-greythr-domain' => $this->getIntegrationUrl('greythr-domain'),
        ];

        $client = new \GuzzleHttp\Client();
        $res = $client->post($url, [
            'body' => json_encode($formParams),
            'headers' => $headers
        ]);

        $return = new stdClass;
        $return->status = $res->getStatusCode();
        $return->data = json_decode($res->getBody()->getContents());
        return $return;
    }

    function generateToken()
    {
        Log::info('token generate start : ' . Carbon::now());
        $url = $this->getIntegrationUrl('company') . 'uas/v1/oauth2/client-token';
        $response = $this->coreGuzzlePost($url);
        if ($response->status == 200) {
            Log::info('token generate end : ' . Carbon::now());
            return isset($response->data->access_token) ? $response->data->access_token : null;
        } else {
            Log::info('access token generation error : ' . json_encode($response));
        }
    }

    function getAllEmployees()
    {
        Log::info('get all employee start : ' . Carbon::now());
        $url = $this->getIntegrationUrl('api') . 'employee/v2/employees';
        $formParams = [
            'page' => 0,
            'size' => 2000,
            'state' => 'CURRENT'
        ];
        $response = $this->coreGuzzleQuery($url, $formParams);
        if ($response->status == 200) {
            // $totalPages = isset($response->data->pages->totalPages) ? $response->data->pages->totalPages : 0;
            $data = $response->data->data;
            $this->addorUpdateEmployee($data);
            // for ($i = 1; $i <= $totalPages; $i++) {
            //     Log::info('page : ' . $i);
            //     $formParams = [
            //         'page' => $i,
            //         'size' => 35,
            //         'state' => 'CURRENT'
            //     ];
            //     $response = $this->coreGuzzleQuery($url, $formParams);
            //     if ($response->status == 200) {
            //         $data = $response->data->data;
            //         $this->addorUpdateEmployee($data);
            //     }
            // }
        } else {
            Log::info('get all employee error : ' . json_encode($response));
        }
        Log::info('get all employee end : ' . Carbon::now());
    }

    function addBranchIfNotExists($data)
    {
        $branch = BranchMaster::select('id')->where('name', $data->valueDesc)->first();
        if (!$branch) {
            $branch = new BranchMaster();
            $branch->name = $data->valueDesc;
            $branch->code = $data->valueDesc;
            $branch->save();
        }
        return $branch->id;
    }

    function addDesignationIfNotExists($data)
    {
        $designation = DesignationMaster::select('id')->where('name', $data->valueDesc)->first();
        if (!$designation) {
            $designation = new DesignationMaster();
            $designation->name = $data->valueDesc;
            $designation->save();
        }
        return $designation->id;
    }

    function addBrandIfNotExists($data)
    {
        $brand = BrandMaster::select('id')->where('name', $data->valueDesc)->first();
        if (!$brand) {
            $brand = new BrandMaster();
            $brand->name = $data->valueDesc;
            $brand->save();
        }
        return $brand->id;
    }

    function addClassIfNotExists($data)
    {
        $class = ClassMaster::select('id')->where('name', $data->valueDesc)->first();
        if (!$class) {
            $class = new ClassMaster();
            $class->name = $data->valueDesc;
            $class->save();
        }
        return $class->id;
    }

    function addRoleIfNotExists($data)
    {
        $role = RoleMaster::select('id')->where('description', $data->valueDesc)->first();
        if (!$role) {
            $role = new RoleMaster();
            $role->description = $data->valueDesc;
            $role->save();
        }
        return $role->id;
    }

    function addorUpdateEmployee($data)
    {
        if ($data) {
            // dd($data);
            foreach ($data as $employee) {

                $this->createTeleCallers($employee);

                // $url = $this->getIntegrationUrl('api') . 'employee/v2/employees/' . $employee->employeeId . '/categories';
                // $formParams = [
                //     'descRequired' => 'true'
                // ];
                // $response = $this->coreGuzzleQuery($url, $formParams);
                // // dd($response);
                // if ($response->status == 200) {
                //     $categories = $response->data;
                //     if ($categories) {

                //         $branchId = null;
                //         $designation = null;
                //         $role = 6;
                //         $brand = null;
                //         $class = null;

                //         // foreach ($categories as $category) {

                //         //     if ($category->category == self::LOCATION_CATEGORY_VALUE) {
                //         //         $branchId = $this->addBranchIfNotExists($category);
                //         //     }
                //         //     if ($category->category == self::DESIGNATION_CATEGORY_VALUE) {
                //         //         $designation = $this->addDesignationIfNotExists($category);
                //         //         // $role = $this->addRoleIfNotExists($category);
                //         //     }
                //         //     if ($category->category == self::BRAND_NAME_CATEGORY_VALUE) {
                //         //         $brand = $this->addBrandIfNotExists($category);
                //         //     }
                //         //     if ($category->category == self::CLASS_CATEGORY_VALUE) {
                //         //         $class = $this->addClassIfNotExists($category);
                //         //     }
                //         // }

                //         foreach ($categories as $category) {

                //             if ($branchId && $category->category == self::DESIGNATION_CATEGORY_VALUE) {

                //                 $params = new stdClass;
                //                 $params->branchId = $branchId;
                //                 $params->designation = $designation;
                //                 $params->role = $role;
                //                 $params->brand = $brand;
                //                 $params->class = $class;

                //                 //create telecallers
                //                 // if (in_array(strtoupper($category->valueDesc), self::TELECALLER_CATEGORIES)) {
                //                 $this->createTeleCallers($employee, $params);
                //                 // }

                //                 //create app users
                //                 // if (in_array(strtoupper($category->valueDesc), self::APP_USERS_CATEGORIES)) {
                //                 //     $this->createAppUsers($employee, $params);
                //                 // }
                //             }
                //         }
                //     }
                // }
            }
        }
    }

    function createTeleCallers($employee)
    {
        // Log::info('phone : ' . $employee->mobile);
        $phone = isset($employee->mobile) ? $employee->mobile : null;
        if ($phone) {
            // $name = isset($employee->name) ? $employee->name : null;
            $empNo = isset($employee->employeeNo) ? $employee->employeeNo : null;
            $empId = isset($employee->employeeId) ? $employee->employeeId : null;
            // $branch = $params->branchId;
            // $designation = $params->designation;
            // $brand = $params->brand;
            // $class = $params->class;
            // $password = '12345';
            // $role = RoleMaster::ROLE_AGENT;

            $data = AgentMaster::withTrashed()->where('phone', $phone)->first();
            // Log::info('agent : ' . json_encode($data));
            // $user = User::withTrashed()->where('email', $phone)->first();
            // Log::info('user : ' . json_encode($user));

            if ($data) {
                // $data = new AgentMaster();
                // $data->name = $name;
                $data->emp_no = $empNo;
                $data->emp_id = $empId;
                // $data->branch_id = $branch;
                $data->phone = $phone;
                // $data->designation = $designation;
                // $data->role = $role;
                // $data->brand = $brand;
                // $data->class = $class;
                $data->greyt_hr_company = $this->type;
                $data->save();
                // $lastId = $data->id;
            }
            // if (!$user) {
            //     $user = new User();
            //     $user->password = Hash::make($password);
            // }

            // $user->name = $name;
            // $user->email = $phone;
            // $user->role = $role;
            // $user->user_type = User::USER_TYPE_AGENT;
            // $user->reference_id = $lastId;
            // $user->save();
        }
    }

    function createAppUsers($employee, $params)
    {
        $email = isset($employee->email) ? $employee->email : null;
        if ($email) {
            $name = isset($employee->name) ? $employee->name : null;
            $phone = isset($employee->mobile) ? $employee->mobile : null;
            $empNo = isset($employee->employeeNo) ? $employee->employeeNo : null;
            $empId = isset($employee->employeeId) ? $employee->employeeId : null;
            $branch = $params->branchId;
            $password = '12345';
            $role = $params->role;

            $data = UserMaster::withTrashed()->where('email', $email)->first();
            $user = User::withTrashed()->where('email', $email)->first();

            if (!$data) {
                $data = new UserMaster();
            }

            if (!$user) {
                $user = new User();
                $user->password = Hash::make($password);
            }

            $data->name = $name;
            $data->emp_no = $empNo;
            $data->emp_id = $empId;
            $data->branch_id = $branch;
            $data->phone = $phone;
            $data->email = $email;
            $data->role = $role;
            $data->greyt_hr_company = $this->type;
            $data->save();
            $lastId = $data->id;

            $user->name = $name;
            $user->email = $email;
            $user->role = $role;
            $user->user_type = User::USER_TYPE_APP_USERS;
            $user->reference_id = $lastId;
            $user->save();
        }
    }

    function fetchAttendance($type)
    {
        try {
            DB::beginTransaction();
            $this->type = $type;
            $this->token = $this->generateToken();
            $this->getAttendance();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('attendance fetching error : ' . $e->getMessage());
        }
    }

    function getAttendance()
    {
        Log::info('getting attendance start : ' . Carbon::now());
        $today = Carbon::now()->format('Y-m-d');
        AgentMaster::where('status', AgentMaster::STATUS_ACTIVE)
            ->where('greyt_hr_company', $this->type)
            ->whereNotNull('emp_no')
            ->chunk(50, function ($agents) use ($today) {
                foreach ($agents as $agent) {
                    if ($agent->emp_id > 0) {

                        $url = $this->getIntegrationUrl('api') . 'attendance/v2/employee/' . $agent->emp_id . '/swipes';
                        $formParams = [
                            'systemSwipes' => 'true',
                            'start' => $today,
                            'end' => $today,
                        ];
                        $response = $this->coreGuzzleQuery($url, $formParams);
                        if ($response->status == 200) {
                            $data = $response->data->list;
                            Log::info('attendance : ' . $agent->emp_id . '' . json_encode($data));
                            if ($data) {
                                $login = AgentsAttendance::where('date', $today)->where('agent_id', $agent->id)->first();
                                foreach ($data as $row) {
                                    if (!$login) {
                                        $login = new AgentsAttendance();
                                        $login->agent_id = $agent->id;
                                        $login->date = $today;
                                    }
                                    if ($row->inOutIndicator == 'IN') {
                                        $login->login_in = AppTimeFormat($row->punchDateTime);
                                    }
                                    if ($row->inOutIndicator == 'OUT') {
                                        $login->log_out = AppTimeFormat($row->punchDateTime);
                                    }
                                    $login->save();
                                }
                            }
                        }
                    }
                }
            });
        Log::info('getting attendance end : ' . Carbon::now());
    }
}
