<?php

namespace App\Services\Transactions;

use App\Models\Feedback;
use App\Models\Masters\EscalationMatrix;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\User;
use Carbon\Carbon;
use DB;
use Log;

class UpdateLevelService
{

    public function __construct()
    {
    }

    public function updateLevels()
    {
        try {
            DB::beginTransaction();
            Log::info('Levels Update started : ' . Carbon::now());
            $feedback = DB::table('feedback')
                ->join('beneficiary_import', 'beneficiary_import.id', 'feedback.beneficiary_ref_id')
                ->where('feedback.status', Feedback::STATUS_ACTIVE)
                ->where('beneficiary_import.status', BeneficiaryImport::STATUS_CALL_FEEDBACK_DONE)
                ->where('feedback.is_compliant', Feedback::IS_COMPLIANT)
                ->where('feedback.resolved_status', Feedback::RESOLVED_STATUS_PENDING)
                ->where('feedback.is_show', 1)
                ->select('feedback.id', 'feedback.created_at', 'feedback.complain_level', 'beneficiary_import.scheme_id', 'beneficiary_import.program_id', 'beneficiary_import.district_id', 'beneficiary_import.awc')
                ->orderBy('feedback.id', 'desc')
                // ->take(5)
                ->get();

            if ($feedback) {
                foreach ($feedback as $row) {

                    $diffDays = $this->calculateDiffDays($row);

                    $authorityDetails = $this->getLevelofficersDetails($row);

                    if ($authorityDetails) {

                        foreach ($authorityDetails as $auth) {

                            if (isset($auth->authId) && $diffDays <= $auth->days) {

                                $notifyLevel = $auth->level + 1;

                                $updateFeedback = Feedback::find($row->id);
                                if (!is_null($updateFeedback->escalated_to)) {
                                    $escalatedTo = $updateFeedback->escalated_to . ',' . $auth->authId;
                                    $escalatedTo = explode(',', $escalatedTo);
                                    $escalatedTo = array_unique($escalatedTo);
                                    $escalatedTo = implode(',', $escalatedTo);
                                } else {
                                    $escalatedTo = $auth->authId;
                                }

                                $updateFeedback->complain_level = $auth->level;
                                $updateFeedback->resolve_to = $auth->authId;
                                $updateFeedback->notify_level = $notifyLevel;
                                $updateFeedback->escalated_to = $escalatedTo;
                                $updateFeedback->save();
                                break;
                            }
                        }
                    }
                }
            }
            DB::commit();
            Log::info('Levels Updated successfully : ' . Carbon::now());
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('Levels Update Error : ' . $e);
            // dd($e);
        }
    }

    public function getLevelofficersDetails($row)
    {
        $sql = $this->getAuthorityLevelCoreSql($row);
        $sql->orderBy('escalation_matrix_levels.level');
        $sql->groupBy('escalation_matrix_levels.mobile');
        $sql->select('escalation_matrix_levels.*', 'block_master.code as blockCode', 'city_master.code as districtCode');
        $authorityDetails = $sql->get();

        if ($authorityDetails) {
            foreach ($authorityDetails as $key => $user) {

                if ($user->level == 2) {
                    $userDet = User::where('email', $user->blockCode)->first();
                } else if ($user->level == 3) {
                    $userDet = User::where('email', $user->districtCode)->first();
                }

                if (isset($userDet)) {
                    $user->authId = $userDet->id;
                }
            }
            return $authorityDetails;
        }
    }

    public function calculateDiffDays($feedback)
    {
        $date = Carbon::parse($feedback->created_at)->format('Y-m-d');
        $now = Carbon::now()->format('Y-m-d');
        $dt = Carbon::create($date);
        $dt2 = Carbon::create($now);
        $diffDays = $dt->diffInDaysFiltered(function (Carbon $date) {
            return !$date->isWeekend();
        }, $dt2);
        return $diffDays;
    }

    public function getAuthorityLevelCoreSql($data)
    {
        $sql = DB::table('escalation_matrix_levels')
            ->join('escalation_matrix', 'escalation_matrix.id', 'escalation_matrix_levels.escalation_reference_id')
            ->join('block_master', 'block_master.id', 'escalation_matrix.block_id')
            ->join('city_master', 'city_master.id', 'escalation_matrix.district_id')
            // ->where('escalation_matrix.scheme_id', $data->scheme_id)
            // ->where('escalation_matrix.program_id', $data->program_id)
            // ->where('escalation_matrix.district_id', $data->district_id)
            ->where('escalation_matrix.awc_id', $data->awc)
            ->where('escalation_matrix.status', EscalationMatrix::STATUS_ACTIVE)
            ->whereNull('escalation_matrix.deleted_at');
        return $sql;
    }
}
