<?php

namespace App\Services;

use App\Models\AgentsLogin;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\UserMaster;
use App\Models\RoleMaster;
use App\Models\User;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Hash;
use Auth;
use Carbon\Carbon;
use stdClass;
use DB;
use Log;

class UserService
{

    private $commonService;
    private $excelCampaignService;

    public function __construct(CommonService $commonService, ExcelCampaignService $excelCampaignService)
    {
        $this->commonService = $commonService;
        $this->excelCampaignService = $excelCampaignService;
    }

    public function getUserData()
    {
        $users = UserMaster::join('role_master', 'role_master.id', 'user_master.role')
            ->select('user_master.*', 'role_master.description as role');
        return $users;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = UserMaster::find($id);
            $data->route = route('user.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            //get user id
            $userData = User::where('email', $data->phone)->first();
            $data->userId = $userData->id;
        } else {
            $data = new UserMaster();
            $data->route = route('user.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }

        $data->breadcrumbAction = route('user.index');
        $data->breadcrumbTitle = 'User';
        return $data;
    }

    public function saveUserData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $email = $request->has('email') ? $request->get('email') : '';
        $phone = $request->has('phone') ? $request->get('phone') : '';
        $password = $request->has('password') ? $request->get('password') : '';
        $role = $request->has('role') ? $request->get('role') : '';
        $userId = $request->has('userId') ? $request->get('userId') : '';
        $uniqueId = $request->has('uniqueId') ? $request->get('uniqueId') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';

        if ($userId) {
            $data = UserMaster::find($uniqueId);
            $data->updated_by = Auth::user()->id;
            $user = User::find($userId);
        } else {
            $data = new UserMaster();
            $user = new User();
            $user->password = Hash::make($password);
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->email = $email;
        $data->branch_id = $branch;
        $data->phone = $phone;
        $data->role = $role;
        $data->save();
        $lastId = $data->id;

        //save data to user table
        if (!$userId) {
            $user->reference_id = $lastId;
        }

        $user->name = $name;
        $user->role = $role;
        $user->email = $phone;
        $user->user_type = User::USER_TYPE_APP_USERS;
        $user->save();

        if ($user) {
            return true;
        }
    }

    function getDistance($lat1, $lon1, $lat2, $lon2, $unit = 'M')
    {
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +
            cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
            cos(deg2rad($theta));
        $dist = acos(min(1, max(-1, $dist)));
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;

        return match (strtoupper($unit)) {
            'K' => $miles * 1.609344,         // kilometers
            'M' => $miles * 1.609344 * 1000,  // meters
            'N' => $miles * 0.8684,           // nautical miles
            default => $miles                 // miles
        };
    }


    public function login(HttpRequest $request)
    {
        // Log::info('login : '. json_encode($request->all()));
        // if (!$request->latitude || !$request->longitude) {
        //     return $this->commonService->makeErrorResponse('user location not available');
        // }

        if (Auth::attempt(['email' => $request->username, 'password' => $request->password])) {
            $user = Auth::user();
            if ($user->status == 0) {
                return $this->commonService->makeErrorResponse('user account is inactive, contact admin');
            }
            //check branch location and user location
            // $branchData = AgentMaster::select('branch_master.latitude', 'branch_master.longitude', 'branch_master.allow_login_distance')
            //     ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            //     ->where('agent_master.id', $user->reference_id)
            //     ->first();
            // if (!$branchData) {
            //     return $this->commonService->makeErrorResponse('branch not mapped for this user');
            // }
            // $distanceInMeters = $this->getDistance($branchData->latitude, $branchData->longitude, $request->latitude, $request->longitude);
            // if ($distanceInMeters > $branchData->allow_login_distance) {
            //     return $this->commonService->makeErrorResponse('login not allowed for this location');
            // }

            $user->player_id = isset($request->playerId) ? $request->playerId : null;
            $user->save();
            // Create a new token
            $user->token = $user->createToken('api')->plainTextToken;
            $user->loginDate = Carbon::now()->format("Y-m-d");
            // Store token with expiration
            $user->tokens()->latest()->first()->update([
                'expires_at' => Carbon::now()->format('Y-m-d 23:59:59')
            ]);
            // $agent = $this->excelCampaignService->getExcelCampaignUserDetails($user);
            // $user->campaignAssignScreen = isset($agent->id) ? true : false;
            $user->campaignAssignScreen = false;
            $this->addAgentLogin($request, 'login');
            return $this->commonService->makeSuccessResponse('User login successfully', $user);
        } else {
            return $this->commonService->makeErrorResponse('unauthorised');
        }
    }

    function appLogout(HttpRequest $request)
    {
        $this->addAgentLogin($request, 'logout');
        $user = new stdClass;
        return $this->commonService->makeSuccessResponse('User logged out successfully', $user);

        // if (DB::table('personal_access_tokens')->where('tokenable_id', $request->user()->id)->update(['deleted_at' => Carbon::now()])) {
        //     $user = new stdClass;
        //     return $this->commonService->makeSuccessResponse('User logged out successfully', $user);
        // }
        // return $this->commonService->makeErrorResponse('failed');
    }

    function addAgentLogin(HttpRequest $request, $type)
    {
        $agentId = $request->user()->reference_id;
        if ($agentId) {
            $today = Carbon::now();
            $login = AgentsLogin::where('date', Carbon::now()->format('Y-m-d'))->where('agent_id', $agentId)->first();
            if (!$login) {
                $login = new AgentsLogin();
                $login->agent_id = $agentId;
                $login->date = Carbon::now()->format('Y-m-d');
                $login->login_in = AppTimeFormat($today);
            } else {
                if ($type == 'logout') {
                    $login->log_out = AppTimeFormat($today);
                }
            }

            $login->save();
        }
    }
}
