<?php

namespace App\View\Components;

use App\Models\Masters\AgentMaster;
use App\Models\User;
use DB;
use Illuminate\View\Component;

class AgentDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;
    private $className;

    public function __construct($selected = null, $label = true, $id = 'agent', $name = "agent", $className = 'common-on-change')
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
        $this->className = $className;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        $className = $this->className;

        // $sql = DB::table('agent_master')
        //     ->where('agent_master.status', 1);
        // $sql->join('users', function ($join) {
        //     $join->on('users.reference_id', '=', 'agent_master.id');
        //     $join->where('users.user_type', User::USER_TYPE_AGENT);
        // });
        // $sql->select('users.id', 'users.name');
        // $agents = $sql->get();

        $agents = AgentMaster::select('id', 'name')->whereStatus(AgentMaster::STATUS_ACTIVE)->get();

        return view('components.agent-drop-down', compact('agents', 'id', 'label', 'selected', 'name', 'className'));
    }
}
