<?php

namespace App\View\Components;

use App\Models\Masters\ClassMaster;
use Illuminate\View\Component;

class ClassDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'class', $name = "class")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $classes = ClassMaster::whereStatus(ClassMaster::STATUS_ACTIVE)->get();
        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        return view('components.class-drop-down', compact('classes', 'id', 'label', 'selected', 'name'));
    }
}
