<?php

namespace App\View\Components;

use Carbon\Carbon;
use Illuminate\View\Component;

class DatePicker extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */

    private $label;
    private $id;
    private $name;
    private $date;

    public function __construct($label = true, $id = 'date', $name = "date", $date = null)
    {
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
        $this->date = $date ?? Carbon::now()->format('m/d/Y');
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $id = $this->id;
        $label = $this->label;
        $name = $this->name;
        $date = $this->date;
        return view('components.date-picker', compact('id', 'label', 'name', 'date'));
    }
}
