<?php

namespace App\View\Components;

use App\Models\Masters\SchemeMaster;
use Illuminate\View\Component;

class SchemeDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'scheme', $name = "scheme")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $schemes = SchemeMaster::whereStatus(SchemeMaster::STATUS_ACTIVE)->get();
        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        return view('components.scheme-drop-down', compact('schemes', 'id', 'label', 'selected', 'name'));
    }
}
