<?php

namespace App\View\Components;

use App\Services\Master\MenuService;
use Illuminate\View\Component;

class SidebarMenu extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */

    public $menuService;

    public function __construct(MenuService $menuService)
    {
        $this->menuService = $menuService;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $menus = $this->menuService->getMenus();
        return view('components.sidebar-menu', compact('menus'));
    }
}
