<?php

namespace App\View\Components;

use App\Models\CRM\Masters\SubDepartments;
use Illuminate\View\Component;

class SubDepartmentDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Sub Department')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $subDepartments = SubDepartments::select('id', 'name')->whereStatus(SubDepartments::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.sub-department-drop-down', compact('subDepartments', 'selected', 'labelText', 'label'));
    }
}
