$(document).ready(function () {
    $('#source').prepend('<option value="All">All</option>');
    getDashboardData();
    var branchUrl = $("#branchUrl").val();
    var agentUrl = $("#agentUrl").val();
    $(document).on("change", ".common-on-change", function () {
        var id = $(this).attr("id");
        if (id == "branch") {
            getAgents(agentUrl, "dashboard");
        } else if (id == "cluster") {
            getBranches(branchUrl, "dashboard");
        }
        getDashboardData();
    });
});

function getDashboardData() {
    $("#global-loader").show();
    var branchIds = $("#branchIds").val();
    var branch = $("#branch option:selected").val();
    var agent = $("#agent option:selected").val();
    var dateRange = $("#date_range").val();
    var cluster = $("#cluster option:selected").val();
    var source = $("#source option:selected").val();

    var url = "get-dashboard-data";

    formData = {
        agent: agent,
        branch: branch,
        dateRange: dateRange,
        cluster: cluster,
        branchIds: branchIds,
        source: source,
    };

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (response) {
            $("#" + response.id).html(response.html);

            $("#global-loader").fadeOut("slow");
        },
        error: function (jqXHR, exception) {},
    });
}

// window.setInterval(getDashboardData, 10000);
