$(document).ready(function () {

    // $('#date_range').daterangepicker();

    var $schemeOption = $("<option/>", {
        value: '0',
        text: 'All'
    });

    var $programOption = $("<option/>", {
        value: '0',
        text: 'All'
    });

    var $districtOption = $("<option/>", {
        value: '0',
        text: 'All'
    });

    var $blockOption = $("<option/>", {
        value: '0',
        text: 'All'
    });

    var $scheme = $('#scheme');
    var $program = $('#program');
    var $district = $('#district');
    var $block = $('#block');

    $scheme.prepend($schemeOption);
    $program.prepend($programOption);
    $district.prepend($districtOption);
    $block.prepend($blockOption);

    $(document).on('change', '.common-on-change', function () {
        var id = $(this).attr('id');
        if (id == 'scheme') {
            getPrograms('caller/get-programs-ajax', 'list');
        }
        if (id == 'district') {
            getBlocks('caller/get-block-ajax', 'list');
        }
        getProgramwiseReport();
    });


    $(document).on('click', '.downloadExcel', function () {
        var input = $("<input>")
            .attr("type", "hidden")
            .attr("name", "type")
            .val("programwise-excel");
        $('#report-form').append(input);
        $('#report-form').submit();
    });

    $(document).on('click', '.downloadExcelDetails', function () {

        var selectedQuestion = $(this).data('question');
        var selectedAnswer = $(this).data('answer');
        var others = $(this).data('others');


        var input = $("<input>").attr("type", "hidden").attr("name", "type").val("programwise-excel-details");
        var question_input = $("<input>").attr("type", "hidden").attr("name", "question").val(selectedQuestion);
        var answer_input = $("<input>").attr("type", "hidden").attr("name", "answer").val(selectedAnswer);
        var others = $("<input>").attr("type", "hidden").attr("name", "others").val(others);

        $('#report-form').append(input);
        $('#report-form').append(question_input);
        $('#report-form').append(answer_input);
        $('#report-form').append(others);

        $('#report-form').submit();
    });

    $(document).on('click', '.programwise-details', function () {
        var selectedScheme = $(this).data('scheme');
        var selectedProgram = $(this).data('program');
        var selectedQuestion = $(this).data('question');
        var selectedAnswer = $(this).data('answer');
        var ques_label = $(this).data('ques-label');
        var others = $(this).data('others');
        var dateRange = $('#date_range').val();

        var input = $("<input>").attr("type", "hidden").attr("name", "type").val("programwise-details");
        var scheme_input = $("<input>").attr("type", "hidden").attr("name", "selectedScheme").val(selectedScheme);
        var program_input = $("<input>").attr("type", "hidden").attr("name", "selectedProgram").val(selectedProgram);
        var question_input = $("<input>").attr("type", "hidden").attr("name", "question").val(selectedQuestion);
        var answer_input = $("<input>").attr("type", "hidden").attr("name", "answer").val(selectedAnswer);
        var ques_label = $("<input>").attr("type", "hidden").attr("name", "quesLabel").val(ques_label);
        var others = $("<input>").attr("type", "hidden").attr("name", "others").val(others);
        var dateRange = $("<input>").attr("type", "hidden").attr("name", "dateRange").val(dateRange);

        $('#report-form').append(input);
        $('#report-form').append(scheme_input);
        $('#report-form').append(program_input);
        $('#report-form').append(question_input);
        $('#report-form').append(answer_input);
        $('#report-form').append(dateRange);
        $('#report-form').append(ques_label);
        $('#report-form').append(others);
        $('#report-form').submit();
    });


});

function getProgramwiseReport() {
    showLoader();
    var formData = {
        scheme: $('#scheme option:selected').val(),
        program: $('#program option:selected').val(),
        district: $('#district option:selected').val(),
        block: $('#block option:selected').val(),
        dateRange: $('#date_range').val(),
    };
    var url = 'programwise-report';
    coreAjaxPost(formData, url);
}

function getDistrictwiseProgramReport() {
    showLoader();
    var formData = {
        scheme: $('#scheme').val(),
        program: $('#program').val(),
        district: $('#district').val(),
        block: $('#block').val(),
        fromDate: $('#fromDate').val(),
        toDate: $('#toDate').val(),
        answer: $('#answer').val(),
        others: $('#others').val(),
        question: $('#question').val(),
        type : 'districtwiseProgramReport'
    };
    var url = 'navigate-report';
    coreAjaxPost(formData, url);
}

getProgramwiseReport();
getDistrictwiseProgramReport();

