$(document).ready(function () {
    $(document).on("click", ".submit", function (e) {
        e.preventDefault();
        $("#tickets-form").parsley().validate();
        if ($("#tickets-form").parsley().isValid()) {
            $("#submitType").val($(this).data("type"));
            $("#tickets-form").submit();
        }
    });

    $(document).on("blur", "#registerMobile", function (e) {
        showLoader();
        $("#customerName").val("");
        $.ajax({
            url: $("#getSalesDetailsUrl").val(),
            type: "POST",
            data: { mobile: $(this).val() },
            dataType: "json",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function (response) {
                if (response && response.customer_name) {
                    $("#customerName").val(response.customer_name);
                }
                hideLoader();
            },
            error: function (jqXHR, exception) {
                hideLoader();
            },
        });
    });

    $(document).on("change", "#branch", function (e) {
        showLoader();
        // $("#subDepartment").find("option").remove();
        $("#users").find("option").remove();
        $.ajax({
            url: $("#getSubDeptUrl").val(),
            type: "POST",
            data: { branch: $(this).val() },
            dataType: "json",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function (response) {
                if (response) {
                    // $.each(response.dept, function (key, value) {
                    //     $("#subDepartment").append(
                    //         `<option value="${value.id}">${value.name}</option>`
                    //     );
                    // });
                    $.each(response.users, function (key, value) {
                        $("#users").append(
                            `<option value="${value.id}">${value.name} - ${value.designation} - ${value.class}</option>`
                        );
                    });
                }
                hideLoader();
            },
            error: function (jqXHR, exception) {
                hideLoader();
            },
        });
    });
    $(document).ready(function () {
        function toggleReasonDropdown() {
            var selectedStatus = $('#ticket_status').val();
            if (selectedStatus == '3') { // Replace 3 with actual close status ID if different
                $('#reason-div').show();
            } else {
                $('#reason-div').hide();
            }
        }
    
        toggleReasonDropdown();
    
        $('#ticket_status').on('change', function () {
            toggleReasonDropdown();
        });
    });    
});
