$(document).ready(function () {

    var date = new Date();
    var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);

    $('#date_range').daterangepicker({
        startDate: firstDay,
        endDate: lastDay
    });

    window.ParsleyValidator
        .addValidator('fileextension', function (value, requirement) {
            var tagslistarr = requirement.split(',');
            var fileExtension = value.split('.').pop();
            var arr = [];
            $.each(tagslistarr, function (i, val) {
                arr.push(val);
            });
            if (jQuery.inArray(fileExtension, arr) != '-1') {
                console.log("is in array");
                return true;
            } else {
                console.log("is NOT in array");
                return false;
            }
        }, 32)
        .addMessage('en', 'fileextension', 'upload only xlsx,xls,csv');


    $(document).on('change', '#call_reason', function () {

        $('#call-skip-datepicker').addClass('d-none');
        $('#call_skip_recording').addClass('d-none');
        $('#call-another-field').addClass('d-none');
        $("#callback_date_time").prop('required', false);
        $("#call_another_number").prop('required', false);

        if ($(this).val() == 4) {
            $('#call-skip-datepicker').removeClass('d-none');
            $("#callback_date_time").prop('required', true);
        }
        else if ($(this).val() == 9 || $(this).val() == 10 || $(this).val() == 6) {
            $('#call_skip_recording').removeClass('d-none');
            if ($(this).val() == 6) {
                $('#call-another-field').removeClass('d-none');
                $("#call_another_number").prop('required', true);
            }
        }

    });


    $(document).on('click', '.skip_reason', function () {
        var id = $(this).data('unique-id');
        var url = $(this).data('url');
        $('#callId').val(id);
        $('#form-submit-url').val(url);
        $('#redirect-url').val('caller.index');
        $('#screen-name').val('caller');
        $('#callSkipModal').modal('show');
    });

    $("#submit-call-reason").on('click', function (e) {

        e.preventDefault();
        
        $('#call-reason-form').parsley().validate();

        if ($('#call-reason-form').parsley().isValid()) {
            showLoader();
            $('#callSkipModal').modal('hide');
            $("#call-reason-form").submit();
        }
    });

    $(document).on('click', '.click-to-call', function () {

        var benId = $(this).data('unique-id');
        var url = $(this).data('url');
        var redirectUrl = $(this).data('redirect-url');

        swal({
            title: "",
            text: "call is in progress, please wait....",
            imageUrl: 'public/img/call_gif.gif',
            showCancelButton: false,
            showConfirmButton: false,
            closeOnConfirm: false,
            showLoaderOnConfirm: true,
            timer: 500,
        }, function () {

            var formData = {
                benId: benId
            };

            $.ajax({
                url: url,
                type: 'POST',
                data: formData,
                dataType: "json",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (response) {

                    if (response.status == true) {
                        swal({
                            title: "Wow!",
                            text: response.msg,
                            type: "success"
                        }, function (isConfirm) {
                            if (isConfirm) {
                                window.location = redirectUrl;
                            }
                        });
                    } else {
                        swal(response.msg);
                    }

                },
                error: function (jqXHR, exception) {

                },
            });

        });
    });

});