@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <td><b>Name : </b></td>
                                        <td>{{ $data->name }}</td>
                                        <td><b>Campaign Validity : </b></td>
                                        <td>{{ AppDateFormat($data->campaign_validity) }}</td>
                                    </tr>
                                    <tr>
                                        <td><b>Voucher Type : </b></td>
                                        <td colspan="3">Import</td>
                                    </tr>
                                    <tr>
                                        <td><b>Referrer : </b></td>
                                        <td colspan="3">
                                            <div class="row">
                                                <div class="col-md-2">GET {{ $data->referrer_get }}</div>
                                                <div class="col-md-2">Value : {{ $data->referrer_value }}</div>
                                                <div class="col-md-2">Voucher Value : {{ $data->referrer_voucher_value }}
                                                </div>
                                                <div class="col-md-3">From : {{ AppDateFormat($data->referrer_from) }}</div>
                                                <div class="col-md-3">To : {{ AppDateFormat($data->referrer_to) }}</div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><b>Beneficiary : </b></td>
                                        <td colspan="3">
                                            <div class="row">
                                                <div class="col-md-2">GET {{ $data->beneficiary_get }}</div>
                                                <div class="col-md-2">Value : {{ $data->beneficiary_value }}</div>
                                                <div class="col-md-2">Voucher Value : {{ $data->beneficiary_voucher_value }}
                                                </div>
                                                <div class="col-md-3">From : {{ AppDateFormat($data->beneficiary_from) }}</div>
                                                <div class="col-md-3">To : {{ AppDateFormat($data->beneficiary_to) }}</div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
