<div class="mt-3">
    <div class="row row-sm">
        <input type="hidden" id="agentUrl" value="{{ route('getAgents') }}">
        <input type="hidden" id="branchUrl" value="{{ route('getBranches') }}">
        <input type="hidden" id="branchIds" value="{{ $data->branchIds }}">
        <div class="col-md-3">
            <label class="form-label">Date Range</label>
            <div class="form-group">
                <div class="row row-sm">
                    <div class="col-lg-12">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="fe fe-calendar  lh--9 op-6"></i>
                                </div>
                            </div><input type="text" class="form-control pull-right common-on-change"
                                id="date_range">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if ($data->showCluster)
            <div class="col-md-3">
                <label class="form-label">Cluster</label>
                <div class="form-group">
                    <div class="row row-sm">
                        <div class="col-md-9">
                            <div class="parsley-select wd-sm-250">
                                <select class="form-control select2 common-on-change" id="cluster">
                                    <option value="All" selected="selected">All</option>
                                    @foreach ($data->cluster as $cluster)
                                        <option value="{{ $cluster->id }}">
                                            {{ $cluster->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        @if ($data->showBranch)
            <div class="col-md-3">
                <label class="form-label">Branch</label>
                <div class="form-group">
                    <div class="row row-sm">
                        <div class="col-md-9">
                            <div class="parsley-select wd-sm-250">
                                <select class="form-control select2 common-on-change" id="branch">
                                    <option value="All" selected="selected">All</option>
                                    @foreach ($data->branch as $branch)
                                        <option value="{{ $branch->id }}">
                                            {{ $branch->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        @if ($data->showAgent)
            <div class="col-md-3">
                <label class="form-label">Agent</label>
                <div class="form-group">
                    <div class="row row-sm">
                        <div class="col-md-9">
                            <div class="parsley-select wd-sm-250">
                                <select class="form-control select2 common-on-change" id="agent">
                                    <option value="All" selected="selected">All</option>
                                    @foreach ($data->agents as $agent)
                                        <option value="{{ $agent->id }}">
                                            {{ $agent->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <div class="col-md-3">
            <label class="form-label">Source</label>
            <x-source-drop-down label="{{ false }}" />
        </div>
    </div>
</div>
