@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-wrap">

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="row row-xs align-items-center mg-b-20">
                                            <div class="col-md-4">
                                                <label class="mg-b-0">Scheme : </label>
                                            </div>
                                            <div class="col-md-8 mg-t-5 mg-md-t-0">
                                                {{ $data->scheme }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="row row-xs align-items-center mg-b-20">
                                            <div class="col-md-4">
                                                <label class="mg-b-0">Program : </label>
                                            </div>
                                            <div class="col-md-8 mg-t-5 mg-md-t-0">
                                                {{ $data->program }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>Form Fields</h4>
                                        {!! $data->formContent !!}
                                    </div>
                                </div>

                                <div class="form-group row justify-content-end mt-3 mb-0">
                                    <div class="col-md-8 pl-md-2">
                                        <a href="{{ $data->breadcrumbAction }}"
                                            class="btn ripple btn-secondary pd-x-30">Back to List</a>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footerScripts')
    <script type="text/javascript">
        $(document).on("click", ".other-options", function() {
            var id = $(this).data('field-id');
            $('#' + id).addClass('d-none');
            if ($(this).is(":checked")) {
                $('#' + id).removeClass('d-none');
            }
        });

        $(document).on("click", ".radio-select", function() {
            var id = $(this).data('field-id');
            $('#' + id).addClass('d-none');
        });
    </script>
@endsection
