@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')
            @include('transactions.feedback-filters')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table feedback-datatable custom-dt-style" id="feedback-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-10p">Call At</th>
                                            <th class="wd-10p">Feedback ID</th>
                                            <th class="wd-10p">Customer Name</th>
                                            <th class="wd-10p">Mobile</th>
                                            <th class="wd-10p">Program</th>
                                            <th class="wd-10p">District</th>
                                            <th class="wd-10p">Resolve <br> Status</th>
                                            <th class="wd-10p">Resolved At<br> level</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@include('transactions.resolve-model')
@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {
            var table = $('.feedback-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('complaint.index') }}",
                    data: function(d) {
                        d.scheme = $('#scheme option:selected').val(),
                            d.program = $('#program option:selected').val(),
                            d.district = $('#district option:selected').val(),
                            d.question = $('#program_questions option:selected').val(),
                            d.answer = $('#program_answer option:selected').val(),
                            d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'dateTime',
                        name: 'feedback.created_at'
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'customer_name',
                        name: 'customer_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'mobile_number'
                    },
                    {
                        data: 'program',
                        name: 'program_master.name'
                    },
                    {
                        data: 'district',
                        name: 'city_master.name'
                    },
                    {
                        data: 'complain_status',
                        name: 'complain_status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'resolved_level',
                        name: 'resolved_level',
                        orderable: false,
                        searchable: false
                    },

                ]
            });

            $(document).on('change', '.common-on-change', function() {
                table.draw();
            });

        });
    </script>
@endsection
