@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="feedback-form" id="feedback-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <input type="hidden" id="agentUrl" value="{{ route('getAgents') }}">

                                <x-branch-drop-down />

                                <x-agent-drop-down />


                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Date</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text">
                                                        <i class="fe fe-calendar lh--9 op-6"></i>
                                                    </div>
                                                </div><input class="form-control fc-datepicker-custom"
                                                    placeholder="MM/DD/YYYY" type="text" name="date" required=""
                                                    data-parsley-required-message="Date is required">

                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Customer Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="customerName" class="form-control" value=""
                                                required="" data-parsley-required-message="Customer Name is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Mobile Number</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="phone" class="form-control" value=""
                                                required="" data-parsley-required-message="Mobile Number is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Description</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea class="form-control" name="description" rows="3"></textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/transactions/feedback.js') }}?{{ appVersion() }}"></script>
@endsection
