@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="user-form" id="user-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method($data->method)
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" value="{{ isset($data->userId) ? $data->userId : '' }}" id="userId"
                                    name="userId">
                                <input type="hidden" value="{{ isset($data->id) ? $data->id : '' }}" id="agentId"
                                    name="agentId">
                                {{-- <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Email</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="email" name="email" id="email" class="form-control"
                                                value="{{ $data->email }}" required=""
                                                data-parsley-required-message="Email is required" data-parsley-type="email"
                                                data-parsley-trigger="focusout" data-parsley-checkemail
                                                data-parsley-checkemail-message="Email Address already Exists">
                                        </div>
                                    </div>
                                </div> --}}

                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Phone</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="phone" class="form-control"
                                                value="{{ $data->phone }}" required=""
                                                data-parsley-required-message="Phone is required"
                                                data-parsley-trigger="focusout" data-parsley-checkemail
                                                data-parsley-checkemail-message="Phone Number already Exists"
                                                @if (isset($data->id)) {{ 'readonly' }} @endif>
                                        </div>
                                    </div>
                                </div>

                                @if (!isset($data->id))
                                    <div class="form-group ">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="password" id="password" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Password is required">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Confirm Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="ConfirmPassword" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Confirm Password is required"
                                                    data-parsley-equalto="#password"
                                                    data-parsley-equalto-message="Password and confirm password must be same">
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                {{-- <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Address</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea class="form-control" placeholder="Address" name="address" rows="3">{{ $data->address }}</textarea>
                                        </div>
                                    </div>
                                </div> --}}

                                {{-- <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Aadhar No</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="aadharNo" class="form-control"
                                                value="{{ $data->aadhar_no }}">
                                        </div>
                                    </div>
                                </div> --}}

                                <x-branch-drop-down selected="{{ $data->branch_id }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Designation</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="designation">
                                                <select class="form-control select2" required="" name="designation"
                                                    data-parsley-required-message="Select Designation"
                                                    data-parsley-class-handler="#designation"
                                                    data-parsley-errors-container="#designationErrorContainer">
                                                    <option label="Select Designation">
                                                    </option>
                                                    @foreach ($data->designationList as $designation)
                                                        <option value="{{ $designation->id }}"
                                                            @if (isset($data->id) && $designation->id == $data->designation) {{ 'selected' }} @endif>
                                                            {{ $designation->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div id="designationErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Brand</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="brand">
                                                <select class="form-control select2" required="" name="brand"
                                                    data-parsley-required-message="Select Brand"
                                                    data-parsley-class-handler="#brand"
                                                    data-parsley-errors-container="#brandErrorContainer">
                                                    <option label="Select Brand">
                                                    </option>
                                                    @foreach ($data->brandList as $brand)
                                                        <option value="{{ $brand->id }}"
                                                            @if (isset($data->id) && $brand->id == $data->brand) {{ 'selected' }} @endif>
                                                            {{ $brand->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div id="brandErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <x-class-drop-down selected="{{ $data->class }}" />

                                {{-- <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Class</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="class">
                                                <select class="form-control select2" required="" name="class"
                                                    data-parsley-required-message="Select Class"
                                                    data-parsley-class-handler="#class"
                                                    data-parsley-errors-container="#classErrorContainer">
                                                    <option label="Select Class">
                                                    </option>
                                                    <option value="HA"
                                                        @if ($data->class == 'HA') {{ 'selected' }} @endif>HA
                                                    </option>
                                                    <option value="CE"
                                                        @if ($data->class == 'CE') {{ 'selected' }} @endif>CE
                                                    </option>
                                                    <option value="SHA"
                                                        @if ($data->class == 'SHA') {{ 'selected' }} @endif>SHA
                                                    </option>
                                                    <option value="ITT"
                                                        @if ($data->class == 'ITT') {{ 'selected' }} @endif>ITT
                                                    </option>
                                                    <option value="Cashier"
                                                        @if ($data->class == 'Cashier') {{ 'selected' }} @endif>
                                                        Cashier</option>
                                                    <option value="Stores"
                                                        @if ($data->class == 'Stores') {{ 'selected' }} @endif>Stores
                                                    </option>
                                                </select>
                                                <div id="classErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                                {{-- <x-role-drop-down selected="{{ $data->role }}"/> --}}

                                {{-- <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Qualification</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="qualification" class="form-control"
                                                value="{{ $data->qualification }}">
                                        </div>
                                    </div>
                                </div> --}}

                                {{-- <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Documents</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="input-group file-browser">
                                                <input type="text" class="form-control border-right-0 browse-file"
                                                    placeholder="Browse" readonly>
                                                <label class="input-group-btn">
                                                    <span class="btn btn-primary">
                                                        Browse <input type="file" name="attachments[]"
                                                            style="display: none;" multiple
                                                            data-parsley-fileextension='pdf,doc,docx'>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">CRM Lead Assign</label>
                                        </div>
                                        <div class="col-md-9">
                                            <label class="custom-switch">
                                                <input type="checkbox" name="crmLeadAssign"
                                                    class="custom-switch-input" @if($data->crm_lead_assign == 1) checked @endif>
                                                <span class="custom-switch-indicator"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">SAP Lead Assign</label>
                                        </div>
                                        <div class="col-md-9">
                                            <label class="custom-switch">
                                                <input type="checkbox" name="sapLeadAssign"
                                                    class="custom-switch-input" @if($data->sap_lead_assign == 1) checked @endif>
                                                <span class="custom-switch-indicator"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Vendor Campaign Lead Assign</label>
                                        </div>
                                        <div class="col-md-9">
                                            <label class="custom-switch">
                                                <input type="checkbox" name="vendorCampaignLeadAssign"
                                                    class="custom-switch-input" @if($data->vendor_campaign_lead_assign == 1) checked @endif>
                                                <span class="custom-switch-indicator"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/masters/agent.js') }}?{{ appVersion() }}"></script>
@endsection
