@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-6 col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="user-form" id="user-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method($data->method)

                                <input type="hidden" value="{{ isset($data->id) ? $data->id : '' }}" id="mappingId"
                                    name="mappingId">


                                <x-branch-drop-down selected="{{ $data->branch_id }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Agent</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="agent">
                                                <select class="form-control select2" required="" name="agent[]" multiple
                                                    data-parsley-required-message="Select Agent"
                                                    data-parsley-class-handler="#agent"
                                                    data-parsley-errors-container="#agentErrorContainer">
                                                    <option label="Select Agent">
                                                    </option>
                                                    @foreach ($data->agentList as $agent)
                                                        <option value="{{ $agent->id }}"
                                                            @if (isset($data->id) && in_array($agent->id, $data->agents)) {{ 'selected' }} @endif>
                                                            {{ $agent->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div id="agentErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
