@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table awc-datatable" id="awc-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">District</th>
                                            <th class="wd-20p">Block</th>
                                            <th class="wd-20p">Sector</th>
                                            <th class="wd-20p">AWC</th>
                                            <th class="wd-20p">Code</th>
                                            <th class="wd-20p">Status</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            var table = $('.awc-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('awc-master.index') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'district_name',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block_name',
                        name: 'block_master.name'
                    },
                    {
                        data: 'sector_name',
                        name: 'sector_master.name'
                    },
                    {
                        data: 'name',
                        name: 'awc_master.name'
                    },
                    {
                        data: 'code',
                        name: 'awc_master.code'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
        });
    </script>
@endsection
