@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">
                            {{-- <div id="cloneDiv" data-prototype='@include('master.branch.lead-mapping-table-clone')'></div> --}}
                            <form class="form-horizontal" name="branch-form" id="branch-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="code" class="form-control"
                                                value="{{ $data->code }}" required=""
                                                data-parsley-required-message="Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">CRM Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="crmCode" class="form-control"
                                                value="{{ $data->crm_code }}" required=""
                                                data-parsley-required-message="CRM Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Justdial Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="justDialCode" class="form-control"
                                                value="{{ $data->justdial_code }}" required=""
                                                data-parsley-required-message="Justdial Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">SAP Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="sapCode" class="form-control"
                                                value="{{ $data->sap_code }}" required=""
                                                data-parsley-required-message="SAP Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Excel Campaign Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="excelCampaignCode" class="form-control"
                                                value="{{ $data->excel_campaign_code }}" required=""
                                                data-parsley-required-message="Excel Campaign Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Address</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea name="address" id="address" class="form-control">{{ $data->address }}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Pincode</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="pincode" class="form-control"
                                                value="{{ $data->pincode }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Calls Per User</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="callsPerUser" class="form-control"
                                                value="{{ $data->calls_per_user }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Leads Mapping</label>
                                        </div>
                                        <div class="col-md-9">
                                            <select class="form-control select2 common-on-change" id="users"
                                                name="users[]" multiple="">
                                                @foreach ($data->users as $user)
                                                    <option value="{{ $user->id }}"
                                                        @if (in_array($user->id, $data->mapping)) @selected(true) @endif
                                                        data-user-phone="{{ $user->phone }}">
                                                        {{ $user->name }} - {{ $user->branchName }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Latitude</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="latitude" class="form-control"
                                                value="{{ $data->latitude }}" required=""
                                                data-parsley-required-message="Latitude is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Longitude</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="longitude" class="form-control"
                                                value="{{ $data->longitude }}" required=""
                                                data-parsley-required-message="Longitude is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Allow Login Distance</label> <small>(In Mtrs)</small>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="allowLoginDistance" class="form-control"
                                                value="{{ $data->allow_login_distance }}" required=""
                                                data-parsley-required-message="Allow Login Distance is required">
                                        </div>
                                    </div>
                                </div>

                                {{-- <div class="row mb-2">
                                    <h5 class="">Leads Mapping</h5>
                                    <div class="col-md-12 table-responsive">
                                        <table class="table table-bordered" id="leads-table">
                                            <thead>
                                                <tr>
                                                    <th>S.NO</th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th class="text-right">
                                                        <a class="btn ripple btn-success btn-sm add-row">
                                                            <i class="fe fe-plus"></i> Add Row
                                                        </a>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($data->mapping as $key => $row)
                                                    @include('master.branch.lead-mapping-table-clone', [
                                                        'key' => $key + 1,
                                                        'row' => $row,
                                                    ])
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div> --}}
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footerScripts')
    <script src="{{ URL::asset('js/masters/branch.js') }}?{{ appVersion() }}"></script>
@endsection
