@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="call-reason-form" id="call-reason-form"
                                action="{{ $data->route }}" data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Dispositions</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="dispositions" class="form-control"
                                                value="{{ $data->dispositions }}" required=""
                                                data-parsley-required-message="Dispositions is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Type</label>
                                        </div>

                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2 common-on-change" required=""
                                                    name="type" id="type"
                                                    data-parsley-required-message="Select Type"
                                                    data-parsley-class-handler="#type"
                                                    data-parsley-errors-container="#typeErrorContainer">
                                                    <option label="Select Type">
                                                    </option>
                                                    <option value="1"
                                                        @if ($data->is_answered == '1') {{ 'selected' }} @endif>
                                                        Connected
                                                    </option>
                                                    <option value="0"
                                                        @if ($data->is_answered == '0') {{ 'selected' }} @endif>
                                                        Not Connected
                                                    </option>
                                                    {{-- <option value="2"
                                                        @if ($data->is_answered == '2') {{ 'selected' }} @endif>
                                                        Both
                                                    </option> --}}
                                                </select>
                                                <div id="typeErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
