@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table call-reason-datatable" id="call-reason-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-25p">Name</th>
                                            <th class="wd-20p">Type</th>
                                            <th class="wd-20p">Status</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            var table = $('.call-reason-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('call-reasons.index') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'callType',
                        name: 'callType'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
        });
    </script>
@endsection
