@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="campaign-form" id="campaign-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Title</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="title" class="form-control"
                                                value="{{ $data->title }}" required=""
                                                data-parsley-required-message="Title is required">
                                        </div>
                                    </div>
                                </div>

                                {{-- <x-branch-drop-down selected="{{ $data->branch_id }}" /> --}}

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Branch</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select wd-sm-250">
                                                <select class="form-control select2 common-on-change" id="branch"
                                                    multiple="" name="branch[]">
                                                    <option value="All"
                                                        @if (in_array('All', $data->branchId)) @selected(true) @endif>
                                                        All</option>
                                                    @foreach ($data->branchList as $branch)
                                                        <option value="{{ $branch->id }}"
                                                            @if (in_array($branch->id, $data->branchId)) @selected(true) @endif>
                                                            {{ $branch->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Description</label>
                                        </div>
                                        <div id="summernote">{!! $data->description !!}</div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success submit" type="button">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script>
        $(document).ready(function() {
            $('#summernote').summernote({
                height: 250, // set editor height
                minHeight: null, // set minimum height of editor
                maxHeight: null, // set maximum height of editor
                focus: false // set focus to editable area after initializing summernote
            });

            $('.inline-editor').summernote({
                airMode: true
            });

            $('.submit').click(function(e) {
                e.preventDefault();
                var description = $('#summernote').summernote('code');
                $('#campaign-form').parsley().validate();
                if ($('#campaign-form').parsley().isValid()) {
                    var input = $("<input>")
                        .attr("type", "hidden")
                        .attr("name", "description")
                        .val(description);
                    $('#campaign-form').append(input);
                    $('#campaign-form').submit();
                }
            });

        });
    </script>
@endsection
