@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table escalation-datatable" id="escalation-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            {{-- <th class="wd-10p">Scheme</th> --}}
                                            {{-- <th class="wd-10p">Program</th> --}}
                                            <th class="wd-20p">District</th>
                                            <th class="wd-20p">Block</th>
                                            <th class="wd-20p">Sector</th>
                                            <th class="wd-20p">Awc</th>
                                            <th class="wd-20p">Code</th>
                                            <th class="wd-10p">Status</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            var table = $('.escalation-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('escalation-matrix.index') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    // {
                    //     data: 'scheme',
                    //     name: 'scheme_master.name',
                    //     orderable: false,
                    //     searchable: false
                    // },
                    // {
                    //     data: 'program',
                    //     name: 'program_master.name',
                    //     orderable: false,
                    //     searchable: false
                    // },
                    {
                        data: 'district',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block',
                        name: 'block_master.name'
                    },
                    {
                        data: 'sector',
                        name: 'sector_master.name'
                    },
                    {
                        data: 'awc',
                        name: 'awc_master.name'
                    },
                    {
                        data: 'code',
                        name: 'awc_master.code'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
        });
    </script>
@endsection
