@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <td><b>Scheme : </b></td>
                                        <td>{{ $data->scheme }}</td>
                                        <td><b>Program : </b></td>
                                        <td>{{ $data->program }}</td>
                                    </tr>
                                    <tr>
                                        <td><b>District : </b></td>
                                        <td>{{ $data->district }}</td>
                                        <td><b>Block : </b></td>
                                        <td>{{ $data->block }}</td>
                                    </tr>
                                    <tr>
                                        <td><b>Sector : </b></td>
                                        <td>{{ $data->sector }}</td>
                                        <td><b>Awc : </b></td>
                                        <td>{{ $data->awc }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">
                            <h4>Escalation Levels</h4>
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Level</th>
                                        <th>Name</th>
                                        <th>Designation</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>District</th>
                                        <th>Days</th>
                                        {{-- <th>Resolving <br> Officer</th> --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data->items as $item)
                                        <tr>
                                            <td>{{ $item->level }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ escalationLevelNames($item->level) }}</td>
                                            <td>{{ $item->mobile }}</td>
                                            <td>{{ $item->email }}</td>
                                            <td>{{ $item->district }}</td>
                                            <td>{{ $item->days }}</td>
                                            {{-- <td>Level {{ $item->resolving_officer }}</td> --}}
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
