@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="privilege-form" id="privilege-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)
                                
                                <x-role-drop-down selected="{{ $data->role_id }}"/>

                                <div class="form-group">

                                    <div class="row mt-3">
                                        <div class="col-md-12">
                                            <div>
                                                <h6 class="main-content-label mb-1">Menus</h6>
                                            </div>
                                            <div aria-multiselectable="true" class="accordion accordion-color"
                                                id="accordion2" role="tablist">
                                                @foreach ($data->menus as $mainKey => $mainMenu)
                                                    <div class="card">
                                                        <div class="card-header" id="headingOne{{ $mainKey }}"
                                                            role="tab">
                                                            <a aria-controls="collapseOne{{ $mainKey }}"
                                                                aria-expanded="false" data-toggle="collapse"
                                                                href="#collapseOne{{ $mainKey }}">{{ $mainMenu->menu_name }}</a>
                                                        </div>
                                                        <div aria-labelledby="headingOne{{ $mainKey }}"
                                                            class="collapse @if ($mainKey == 0) show @endif"
                                                            data-parent="#accordion2" id="collapseOne{{ $mainKey }}"
                                                            role="tabpanel">
                                                            <div class="card-body">
                                                                <div class="table-responsive">
                                                                    <table
                                                                        class="table card-table table-striped table-vcenter text-nowrap mb-0">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>Menu Name</th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="create"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Create</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="view"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>View</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="edit"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Edit</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="delete"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Delete</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="active"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Active</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="inactive"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Inactive</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="print"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Print</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="import"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Import</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="export"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Export</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div
                                                                                        class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="approve"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Approve</span></label>
                                                                                    </div>
                                                                                </th>
                                                                                <th>
                                                                                    <div
                                                                                        class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                        <label class="ckbox"><input
                                                                                                class="selectAll"
                                                                                                data-field="reject"
                                                                                                data-menu="{{ $mainKey }}"
                                                                                                type="checkbox"><span>Reject</span></label>
                                                                                    </div>
                                                                                </th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @foreach ($mainMenu->subMenu as $subKey => $subMenu)
                                                                                <tr>
                                                                                    <td>{{ $subMenu->menu_name }}</td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="create_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][create]"
                                                                                                    @checked($subMenu->create)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="view_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][view]"
                                                                                                    @checked($subMenu->view)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="edit_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][edit]"
                                                                                                    @checked($subMenu->edit)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="delete_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][delete]"
                                                                                                    @checked($subMenu->delete)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="active_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][active]"
                                                                                                    @checked($subMenu->active)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="inactive_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][inactive]"
                                                                                                    @checked($subMenu->inactive)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="print_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][print]"
                                                                                                    @checked($subMenu->print)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="import_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][import]"
                                                                                                    @checked($subMenu->import)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="export_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][export]"
                                                                                                    @checked($subMenu->export)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="approve_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][approve]"
                                                                                                    @checked($subMenu->approve)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                    <td>
                                                                                        <div
                                                                                            class="col-lg-3 mg-t-20 mg-lg-t-0">
                                                                                            <label class="ckbox"><input
                                                                                                    class="reject_{{ $mainKey }}_checkBox"
                                                                                                    type="checkbox"
                                                                                                    name="menu[{{ $subMenu->p_menu }}][{{ $subMenu->id }}][reject]"
                                                                                                    @checked($subMenu->reject)><span></span></label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            @endforeach

                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach

                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->editMode))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/masters/privileges.js') }}?{{ appVersion() }}"></script>
@endsection
