@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">

        <div class="inner-body">
            <form name="report-form" id="report-form" method="POST" action="{{ $data->route }}">
                @csrf
                @method('POST')
                <input type="hidden" name="fieldType" id="fieldType"
                    value="{{ isset($data->fieldType) ? $data->fieldType : '' }}">
                <input type="hidden" name="refId" id="refId" value="{{ isset($data->refId) ? $data->refId : '' }}">
                <input type="hidden" name="escId" id="escId" value="{{ isset($data->escId) ? $data->escId : '' }}">
                <input type="hidden" name="level" id="level" value="{{ isset($data->level) ? $data->level : '' }}">

                <div class="row row-sm">
                    <div class="col-md-12">
                        <button class="btn btn-success btn-icon-text my-2 mr-2 pull-right downloadExcelOfficersDashboard">
                            <i class="fe fe-download mr-2"></i> Excel
                        </button>
                    </div>
                </div>
            </form>
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table dashboard-datatable custom-dt-style" id="dashboard-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Feedback No</th>
                                            <th class="wd-20p">Ben Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Call Date</th>
                                            <th class="wd-20p">Call By</th>
                                            <th class="wd-20p">Scheme</th>
                                            <th class="wd-20p">Program</th>
                                            <th class="wd-20p">District</th>
                                            <th class="wd-20p">Block</th>
                                            <th class="wd-20p">AWC</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@include('transactions.resolve-model')
@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {
            var table = $('.dashboard-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('dashboard.detailedReportAjax') }}",
                    data: function(d) {
                        d.fieldType = $('#fieldType').val(),
                            d.refId = $('#refId').val(),
                            d.level = $('#level').val(),
                            d.escId = $('#escId').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'parent_name',
                        name: 'beneficiary_import.parent_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'beneficiary_import.mobile_number'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'created_user',
                        name: 'users.name'
                    },
                    {
                        data: 'scheme_name',
                        name: 'scheme_master.name'
                    },
                    {
                        data: 'program_name',
                        name: 'program_master.name'
                    },
                    {
                        data: 'district_name',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block_name',
                        name: 'block_master.name'
                    },
                    {
                        data: 'awc_name',
                        name: 'awc_master.name'
                    }
                ]

            });

            $(".downloadExcel").on('click', function(e) {
                e.preventDefault();
                $('#report-form').submit();
            });

        });
    </script>
@endsection
