@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row row-sm">
            <div class="col-lg-12">
                @include('reports.report_filters-label')
            </div>
            <div class="col-lg-12">
                <div class="card-body">
                    <div id="districtwise-report-content"></div>
                </div>
            </div>
            <div class="col-lg-12">
                <button class="btn btn-success btn-icon-text my-2 mr-2 pull-right downloadExcel">
                    <i class="fe fe-download mr-2"></i> Excel
                </button>
            </div>
        </div>
        <div class="inner-body">

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table dashboard-datatable" id="dashboard-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Ben Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Call Date</th>
                                            {{-- <th class="wd-20p">Call By</th> --}}
                                            <th class="wd-20p">Skip Reason</th>
                                            {{-- <th class="wd-20p">Scheme</th> --}}
                                            <th class="wd-20p">Program</th>
                                            <th class="wd-20p">District</th>
                                            <th class="wd-20p">Block</th>
                                            <th class="wd-20p">AWC</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            var table = $('.dashboard-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('dashboard.detailedReportAjax') }}",
                    data: function(d) {
                        d.scheme = $('#scheme').val(),
                            d.program = $('#program').val(),
                            d.district = $('#district').val(),
                            d.block = $('#block').val(),
                            d.fromDate = $('#fromDate').val(),
                            d.toDate = $('#toDate').val(),
                            d.fieldType = $('#fieldType').val(),
                            d.refId = $('#refId').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'parent_name',
                        name: 'beneficiary_import.parent_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'beneficiary_import.mobile_number'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    // {
                    //     data: 'created_user',
                    //     name: 'users.name'
                    // },
                    {
                        data: 'skipReason',
                        name: 'call_skip_reason.name',
                        orderable: false,
                        searchable: false
                    },
                    // {
                    //     data: 'scheme_name',
                    //     name: 'scheme_master.name'
                    // },
                    {
                        data: 'program_name',
                        name: 'program_master.name'
                    },
                    {
                        data: 'district_name',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block_name',
                        name: 'block_master.name'
                    },
                    {
                        data: 'awc_name',
                        name: 'awc_master.name'
                    }
                ]

            });

            $(".downloadExcel").on('click', function(e) {
                e.preventDefault();
                $('#report-form').submit();
            });

        });


        function getDistrictwiseReport() {
            showLoader();
            var formData = {
                scheme: $('#scheme').val(),
                program: $('#program').val(),
                district: $('#district').val(),
                block: $('#block').val(),
                fromDate: $('#fromDate').val(),
                toDate: $('#toDate').val(),
                fieldType: $('#fieldType').val(),
                refId: $('#refId').val(),
                type: 'districtwiseDashboardReport'
            };
            var url = "{{ route('navigateReport') }}";
            coreAjaxPost(formData, url);
        }

        getDistrictwiseReport();

    </script>
@endsection
