@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        .dt-buttons {
            margin-top: 0px !important;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => false,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'branch' => true,
                'agent' => true,
                'month' => true,
                'year' => true,
            ])
            <button class="btn btn-success getReport">Get Report</button>
            <div class="row row-sm mt-3">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div id="reportTblBody"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script>
        $(document).on('click', '.getReport', function() {
            getReport();
        });

        function getReport() {
            showLoader();
            $('#reportTblBody').empty();
            var formData = {
                branch: $('#branch').val(),
                agent: $('#agent').val(),
                years: $('#years').val(),
                months: $('#months').val(),
            }
            $.ajax({
                url: "{{ route('getEmployeeData') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function(response) {
                    $('#reportTblBody').html(response.html);
                    $('#employee-summary').DataTable({
                        dom: 'Bfrtip',
                        buttons: [{
                            extend: 'excelHtml5',
                            text: 'Excel',
                            title: 'Employee Summary',
                            className: 'btn btn-warning',
                        }]
                    });
                    $(".buttons-html5").removeClass("btn-light");
                    hideLoader();
                },
                error: function(jqXHR, exception) {
                    hideLoader();
                },
            });
        }
        getReport();
    </script>
@endsection
