@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'date' => true,
                'cluster' => true,
                'branch' => true,
                'agent' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 nologin-nocalls-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Date</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Emp Name</th>
                                            <th class="wd-20p">Emp Code</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.nologin-nocalls-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('nologin-nocalls') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.agent = $('#agent option:selected').val(),
                            d.cluster = $('#cluster option:selected').val(),
                            d.date = $('#date').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'date',
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name',
                    },
                    {
                        data: 'agentId',
                        name: 'agent_master.emp_no',
                    }

                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            $(document).on("click", ".downloadReport", function() {
                var input = $("<input>")
                    .attr("type", "hidden")
                    .attr("name", "type")
                    .val("nocalls-nologin-report-excel");
                $("#report-form").append(input);
                $("#report-form").submit();
            });

        });
    </script>
@endsection
