@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 no-login-no-calls-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">No of Users</th>
                                            <th class="wd-20p">No of Logins</th>
                                            <th class="wd-20p">No of Calls Allocated</th>
                                            <th class="wd-20p">No of Calls Dialled</th>
                                            <th class="wd-20p">Connected Calls</th>
                                            <th class="wd-20p">Not Connected Calls</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.no-login-no-calls-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('no-login-no-calls') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'usersCount',
                        name: 'usersCount',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'loginCount',
                        name: 'loginCount',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'allocatedCalls',
                        name: 'allocatedCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'dialledCalls',
                        name: 'dialledCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'connectedCalls',
                        name: 'connectedCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'notConnectedCalls',
                        name: 'notConnectedCalls',
                        orderable: false,
                        searchable: false
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            $(document).on("click", ".downloadReport", function() {
                var input = $("<input>")
                    .attr("type", "hidden")
                    .attr("name", "type")
                    .val("nologin-nocalls-report-excel");
                $("#report-form").append(input);
                $("#report-form").submit();
            });

        });
    </script>
@endsection
