@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 referral-report-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Sales Date</th>
                                            <th class="wd-20p">Customer Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Purchase Amount</th>
                                            <th class="wd-20p">Voucher Code</th>
                                            <th class="wd-20p">Voucher Amount</th>
                                            <th class="wd-20p">Referral Voucher Code</th>
                                            <th class="wd-20p">Referral Voucher Amount</th>
                                            <th class="wd-20p">Claimed Branch</th>
                                            <th class="wd-20p">Sales Date</th>
                                            <th class="wd-20p">Referred To Name</th>
                                            <th class="wd-20p">Referred To Mobile</th>
                                            <th class="wd-20p">Purchase Amount</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    {{-- <script src="{{ URL::asset('js/referral-report.js') }}?{{ appVersion() }}"></script> --}}
    <script type="text/javascript">
        $(function() {

            var table1 = $('.referral-report-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('referral-report') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val();
                        d.dateRange = $('#date_range').val();
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'salesDate',
                        name: 'salesDate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'customer_name',
                        name: 'sales.customer_name'
                    },
                    {
                        data: 'mobile',
                        name: 'sales.mobile'
                    },
                    {
                        data: 'amount',
                        name: 'sales.amount'
                    },
                    {
                        data: 'coupon_code',
                        name: 'customer_coupons.coupon_code'
                    },
                    {
                        data: 'coupon_amount',
                        name: 'customer_coupons.coupon_amount'
                    },
                    {
                        data: 'voucher_code',
                        name: 'referrer_vouchers.voucher_code'
                    },
                    {
                        data: 'referralAmount',
                        name: 'referrer_vouchers.amount'
                    },
                    {
                        data: 'claimedBranchName',
                        name: 'claimedBranch.name'
                    },
                    {
                        data: 'ReferredSalesDate',
                        name: 'ReferredSalesDate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'referredToCustomerName',
                        name: 'referrerSales.customer_name'
                    },
                    {
                        data: 'referredToMobile',
                        name: 'referrerSales.mobile'
                    },
                    {
                        data: 'referredToAmount',
                        name: 'referrerSales.amount'
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });


            $(document).on("click", ".downloadReport", function() {
                var input = $("<input>")
                    .attr("type", "hidden")
                    .attr("name", "type")
                    .val("referral-report-excel");
                $("#report-form").append(input);
                $("#report-form").submit();
            });

        });
    </script>
@endsection
