@extends('templates.layout-main')
<style>
    .dataTable-col-numbers {
        width: 50px !important;
        word-wrap: break-word !important;
    }
</style>
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports')

            @include('report_filters', [
                'scheme' => true,
                'program' => true,
                'district' => true,
                'block' => true,
                'dateFilter' => true,
                'submit' => false,
            ])

            <div class="row row-sm">
                <div class="col-md-12">
                    <button class="btn btn-success btn-icon-text my-2 mr-2 pull-right downloadExcelResolved">
                        <i class="fe fe-download mr-2"></i> Excel
                    </button>
                </div>
            </div>
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table resolved-datatable custom-dt-style" id="resolved-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Complaint <br> No</th>
                                            <th class="wd-20p">Customer Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Program</th>
                                            <th class="wd-10p">District</th>
                                            <th class="wd-10p">Resolved <br>By</th>
                                            <th class="wd-10p">Resolved <br>At</th>
                                            <th class="wd-10p">Resolved <br>Level</th>
                                            <th class="wd-10p">Resolved <br>Reason</th>
                                            <th width="wd-10p">Remarks</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table = $('.resolved-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('resolved-report') }}",
                    data: function(d) {
                        d.scheme = $('#scheme option:selected').val(),
                            d.program = $('#program option:selected').val(),
                            d.district = $('#district option:selected').val(),
                            d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'customer_name',
                        name: 'customer_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'mobile_number'
                    },
                    {
                        data: 'programName',
                        name: 'program_master.name'
                    },
                    {
                        data: 'cityName',
                        name: 'city_master.name'
                    },
                    {
                        data: 'resolvedBy',
                        name: 'users.name'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'resolved_level',
                        name: 'feedback.resolved_level'
                    },
                    {
                        data: 'resolvedReason',
                        name: 'resolve_reasons.name'
                    },
                    {
                        data: 'resolved_remarks',
                        name: 'feedback.resolved_remarks'
                    },
                ],

            });

            $(document).on('change', '.common-on-change', function() {
                table.draw();
            });
        });
    </script>
@endsection
