@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        .vendor-campaign-datatable td:nth-child(19) {
            white-space: normal;
            word-wrap: break-word;
            word-break: break-all;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
                'cluster' => true,
                'agent' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 vendor-campaign-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Date Time</th>
                                            <th class="wd-20p">Customer Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Agent Name</th>
                                            <th class="wd-20p">Read Status</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.vendor-campaign-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('vendor-campaign') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val(),
                            d.cluster = $('#cluster').val(),
                            d.agent = $('#agent').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'createdTime',
                        name: 'createdTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name'
                    },
                    {
                        data: 'readStatus',
                        name: 'readStatus',
                        orderable: false,
                        searchable: false
                    },
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            $(document).on("click", ".downloadReport", function() {
                var input = $("<input>")
                    .attr("type", "hidden")
                    .attr("name", "type")
                    .val("vendor-campaign-excel");
                $("#report-form").append(input);
                $("#report-form").submit();
            });

        });
    </script>
@endsection
