@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            @if ($data->response->status)
                                @foreach ($data->response->msg as $msg)
                                    <div class="alert alert-outline-success mt-2" role="alert">
                                        <strong>Well done!</strong> {{ $msg }}
                                    </div>
                                @endforeach
                            @else
                                @foreach ($data->response->msg as $msg)
                                    <div class="alert alert-outline-danger mt-2" role="alert">
                                        <strong>Oh snap!</strong> {{ $msg }}
                                    </div>
                                @endforeach
                            @endif

                            <div class="form-group">
                                <div class="row row-sm">
                                    <div class="col-md-9">
                                        <a href="{{ $data->backToLink }}" class="btn ripple btn-success">
                                            <i class="fe fe-check-circle"></i> Back to Import
                                        </a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
