@extends('templates.layout-main')
@section('content')
    <style>
        .table-responsive {
            max-height: 400px;
            overflow-y: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }

        thead th {
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            background: #f1f1f1;
            z-index: 1;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="call-mapping-form" id="call-mapping-form"
                                action="{{ $data->route }}" data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <div class="row">
                                    <input type="hidden" id="productUrl" value="{{ route('getProducts') }}">
                                    <input type="hidden" id="agentUrl" value="{{ route('getAgents') }}">
                                    <input type="hidden" id="customerListUrl" value="{{ route('getCustomerList') }}">
                                    <div class="col-md-3">
                                        <x-branch-drop-down />
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">Product</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2" multiple="" name="product[]"
                                                            id="product">
                                                            <option label="Select Product">
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">Agent</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2" multiple="" name="agent[]"
                                                            id="agent">
                                                            <option label="Select Agent">
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <button class="btn ripple btn-success getData" type="button">
                                            <i class="fe fe-check-circle"></i> Get Data
                                        </button>
                                    </div>
                                </div>
                                <div class="row">
                                    <h4>Call Mapping</h4>
                                    <div class="col-md-12 table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <label class="ckbox"><input class="selectAll"
                                                                type="checkbox"><span></span></label>
                                                    </th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th>Date</th>
                                                    <th>Description</th>
                                                </tr>
                                            </thead>
                                            <tbody id="mapping-tbody">

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success submitMapping" type="button">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/call-mapping.js') }}?{{ appVersion() }}"></script>
@endsection
